theory question_44_6
imports Main

begin

typedecl entity
typedecl event

consts
  BoxingMatch :: "event ⇒ bool"
  PhysicalActivity :: "event ⇒ bool"
  Man :: "entity ⇒ bool"
  ParticipatingIn :: "event ⇒ entity ⇒ entity ⇒ bool"
  InvolvedIn :: "event ⇒ entity ⇒ entity ⇒ bool"
  ManInRedTrunks :: "entity ⇒ bool"
  ManInPurpleTrunks :: "entity ⇒ bool"
  Hitting :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: A boxing match is a physical activity involving two men. *)
axiomatization where
  explanation_1: "∀e. BoxingMatch e ⟶ PhysicalActivity e ∧ (∃x y. Man x ∧ Man y ∧ InvolvedIn e x y)"

(* Explanation 2: Two men participating in a boxing match are involved in a physical activity. *)
axiomatization where
  explanation_2: "∀x y e. Man x ∧ Man y ∧ ParticipatingIn e x y ⟶ PhysicalActivity e ∧ InvolvedIn e x y"

theorem hypothesis:
  (* Premise: Two men are in a boxing match where a man in the red boxing trunks is hitting the man in the purple trunks. *)
  assumes asm: "Man x ∧ Man y ∧ BoxingMatch e ∧ In x e ∧ In y e ∧ ManInRedTrunks x ∧ ManInPurpleTrunks y ∧ Hitting e x y"
  (* Hypothesis: The two men are involved in a physical activity. *)
  shows "∃e. PhysicalActivity e ∧ InvolvedIn e x y"
proof -
  from asm have "Man x" "Man y" "BoxingMatch e" "In x e" "In y e" "Hitting e x y" by auto
  then have "PhysicalActivity e" "InvolvedIn e x y" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
