theory question_61_7
imports Main

begin

typedecl entity
consts
  LargestBodyInSolarSystem :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"

(* Explanation 1: The Sun is the unique largest celestial body in the solar system. *)
axiomatization where
  explanation_1: "∃x. LargestBodyInSolarSystem x ∧ Sun x ∧ [(∀y. LargestBodyInSolarSystem y ⟹ y = x)]"

(* Explanation 2: The largest body in the solar system is a celestial body and is the Sun. *)
axiomatization where
  explanation_2: "∃x. LargestBodyInSolarSystem x ∧ Sun x ∧ CelestialBody x"

theorem hypothesis:
  assumes asm: "CelestialBody x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "∃x. LargestBodyInSolarSystem x ∧ Sun x"
proof -
  have "∃x. LargestBodyInSolarSystem x ∧ Sun x" using explanation_1 by blast
  then show ?thesis by blast
qed

end
