theory question_72_0

imports Main

begin

typedecl entity
typedecl event

consts
  SecondaryMeristem :: "entity ⇒ bool"
  VascularTissues :: "entity ⇒ bool"
  LocatedWithin :: "entity ⇒ entity ⇒ bool"
  LocatedAround :: "entity ⇒ entity ⇒ bool"
  SecondaryMeristems :: "entity ⇒ bool"
  Stem :: "entity ⇒ bool"
  Root :: "entity ⇒ bool"
  Make :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  GrowLargerInDiameter :: "entity ⇒ bool"

(* Explanation 1: Secondary meristem is located within and around the vascular tissues. *)
axiomatization where
  explanation_1: "∀x y. SecondaryMeristem x ∧ VascularTissues y ⟶ (LocatedWithin x y ∧ LocatedAround x y)"

(* Explanation 2: Secondary meristems make the stem or root grow larger in diameter. *)
axiomatization where
  explanation_2: "∀x y e. SecondaryMeristems x ∧ (Stem y ∨ Root y) ∧ Make e ∧ Agent e x ∧ Patient e y ∧ GrowLargerInDiameter y"

theorem hypothesis:
  assumes asm: "VascularTissues x ∧  Stem y ∨ Root y "
  (* Hypothesis: Vascular tissues make the stem or root grow larger in diameter. *)
  shows "∃e. Make e ∧ Agent e x ∧ Patient e y ∧ GrowLargerInDiameter y"
proof -
  {
    assume "SecondaryMeristem z" for z
    from explanation_1[OF this] have "LocatedWithin z x ∧ LocatedAround z x" by blast
    from explanation_2[OF this, OF ‹Stem y ∨ Root y›]
    have "∃e. Make e ∧ Agent e z ∧ Patient e y ∧ GrowLargerInDiameter y" by blast
  }
  then obtain z where "SecondaryMeristem z" and "∃e. Make e ∧ Agent e z ∧ Patient e y ∧ GrowLargerInDiameter y"
    using asm by blast
  then obtain e where "Make e ∧ Agent e z ∧ Patient e y ∧ GrowLargerInDiameter y" by blast
  then show ?thesis using asm `VascularTissues x` `Stem y ∨ Root y` by blast
qed

end
