theory question_26_0

imports Main

begin

typedecl entity
typedecl event

consts
  Phytoplankton :: "entity ⇒ bool"
  Sunlight :: "entity ⇒ bool"
  Live :: "event ⇒ bool"
  Need :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Phytoplankton, or plant plankton, needs sunlight to live, the same way plants on land do. *)
axiomatization where
  explanation_1: "∀x y e. Phytoplankton x ∧ Sunlight y ∧ Live e ∧ Need e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "Phytoplankton x ∧ Sunlight y ∧ Live e ∧ Need e"
  (* Hypothesis: Plant plankton need sunlight for food. *)
  shows "∃x y z e. Phytoplankton x ∧ Sunlight y ∧ Food z ∧ Need e ∧ Agent e x ∧ Patient e y ∧ Live e"
proof -
  from asm have "Phytoplankton x ∧ Sunlight y ∧ Live e ∧ Need e" by simp
  then obtain z where z: "Food z ∧ Need e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then have "Phytoplankton x ∧ Sunlight y ∧ Food z ∧ Live e" using z by simp
  show ?thesis using asm z by blast
qed

end
