theory question_85_4

imports Main

begin

typedecl entity
typedecl event

consts
 FlowerSeller :: "entity ⇒ bool"
 Vendor :: "entity ⇒ bool"
 Sidewalk :: "entity ⇒ bool"
 SellerOfFlowers :: "entity ⇒ bool"
 Selling :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A flower seller exists on the sidewalk. *)
axiomatization where
 explanation_1: "∀x. FlowerSeller x ⟶ Exists x Sidewalk"

(* Explanation 2: Vendor is a seller of flowers. *)
axiomatization where
 explanation_2: "∀x. Vendor x ⟶ SellerOfFlowers x ∧ Selling e ∧ Agent e x"

theorem hypothesis:
 (* Premise: Sidewalk flower cart vendor. *)
 assumes asm: "Sidewalk x  ∧ FlowerCart y  ∧ Vendor z  ∧ Vending e  ∧ Agent e  z  ∧ Patient e  y  ∧ InFrontOf x  y "
 (* Hypothesis: Flower seller on sidewalk. *)
 shows "∃x y e. FlowerSeller x  ∧ Sidewalk y  ∧ Selling e  ∧ Agent e  x  ∧ Patient e  y "
proof -
 from asm have "FlowerSeller x" by blast
 then have "Sidewalk y ∧ Selling e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
 then show ?thesis using `FlowerSeller x` `Sidewalk y` by blast
qed

end
