theory question_6_0
imports Main
begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Tumble :: "event ⇒ bool"
  Spectator :: "entity ⇒ bool"
  Watch :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  UniversityOfMichigan :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A man tumbles as spectators watch is the same as spectators watch a man tumble. *)
axiomatization where
  explanation_1: "∀x y e. Man(y) ∧ Tumble(e) ∧ Spectator(x) ∧ Watch(e, x) ⟶ Agent(e, y)"

theorem hypothesis:
  (* Premise: A man tumbles as spectators watch at the University of Michigan. *)
  assumes asm: "Man y  ∧ Tumble e  ∧ Spectator x  ∧ Watch e  x  ∧ UniversityOfMichigan z  ∧ In e  z "
  (* Hypothesis: Spectators watch a man tumble. *)
  shows "∃x y e. Spectator x  ∧ Man y  ∧ Tumble e  ∧ Agent e  y "
proof -
  from asm have "Spectator x" by blast
  from asm have "Man y" by blast
  from explanation_1 have "Tumble e" by blast
  from explanation_1 have "Agent e y" by blast
  from asm have "Watch e x" by blast
  from explanation_1 have "Spectator x" by blast
  show ?thesis using `Spectator x` `Man y` `Tumble e` `Agent e y` `Watch e x` by blast
qed

end
