theory question_26_0

imports Main

begin

typedecl entity
typedecl event
consts
  CrowdOfPeople :: "entity ⇒ bool"
  Directing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  HerdingPedestrians :: "entity ⇒ bool"
  Policeman :: "entity ⇒ bool"

(* Explanation 1: Directing a crowd of people is another expression of herding pedestrians. *)
axiomatization where
  explanation_1: "∀x y e. CrowdOfPeople y ∧ Directing e ∧ Agent e x ∧ Patient e y ⟶ HerdingPedestrians x"

theorem hypothesis:
  (* Premise: A policeman is directing a crowd of people walking. *)
  assumes asm: "Policeman x ∧ CrowdOfPeople y ∧ Walking z ∧ Directing e ∧ Agent e x ∧ Patient e y ∧ In e z"
  (* Hypothesis: A policeman is herding pedestrians. *)
  shows "∃x y e. Policeman x ∧ Pedestrians y ∧ Herding e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Policeman x" by blast
  from this have "HerdingPedestrians x" using explanation_1 by blast
  show ?thesis using `Policeman x` `HerdingPedestrians x` by blast
qed

end
