theory question_63_0

imports Main

begin

typedecl entity
typedecl event

consts
  SedimentaryRocks :: "entity ⇒ bool"
  Deposition :: "entity ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"
  Rocks :: "entity ⇒ bool"

(* Explanation 1: sedimentary rocks are formed by deposition *)
axiomatization where
  explanation_1: "∀x y. SedimentaryRocks x ∧ Deposition y ⟶ (∃e. Formed e ∧ Agent e x ∧ Patient e y)"

(* Explanation 2: Sedimentary Rocks One of the commonest sedimentary rocks is sandstone. *)
axiomatization where
  explanation_2: "∀x. SedimentaryRocks x ⟶ Sandstone x"  

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition y"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "∃x y e. Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e x ∧ Patient e y ∧ Sandstone x"
proof -
  from asm have "Rocks x ∧ Deposition y" by simp
  then obtain e where e: "Formed e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then have "Sandstone x" using explanation_2 by blast
  have conclusion: "Formed e ∧ Agent e x ∧ Patient e y" using e by simp
  show ?thesis using asm conclusion `Sandstone x` by blast
qed

end
