theory question_89_6

imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"

(* Explanation 1: Mountain biking in the forest during the early fall occurs in autumn. *)
axiomatization where
  explanation_1: "∃x y z e. MountainBiking x ∧ Forest y ∧ EarlyFall z ∧ In x y ∧ In x z"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking x ∧ Forest y ∧ EarlyFall z ∧ In x y ∧ In x z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling x ∧ Woods y ∧ Autumn z ∧ In x y ∧ In x z"
proof -
  from asm have "MountainBiking x ∧ Forest y ∧ EarlyFall z ∧ In x y ∧ In x z" by blast
  then have "Bicycling x ∧ Woods y ∧ Autumn z ∧ In x y ∧ In x z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
