theory question_82_5

imports Main

begin

typedecl entity
typedecl event

consts
  Working :: "entity ⇒ bool"
  ElectricTools :: "entity ⇒ bool"
  SwimmingPool :: "entity ⇒ bool"
  Dangerous :: "entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Working x ∧ ElectricTools y ∧ SwimmingPool z"
  (* Hypothesis: Working with electric tools beside a swimming pool would be the most dangerous. *)
  shows "Dangerous x"
proof -
  from asm have danger_tools: "Dangerous y" if "ElectricTools y" for y using Dangerous_def by blast
  from asm have swimming_pool_danger: "Dangerous z" using Dangerous_def SwimmingPool_def by blast
  from asm have asm_danger: "Dangerous x ∨ Dangerous y ∨ Dangerous z" by (rule conjI; rule disjI)
  show ?thesis using asm_danger by (rule conjI; rule disjE; assumption)
qed

end
