theory question_61_0

imports Main

begin

typedecl entity

consts
  Earth :: "entity ⇒ bool"
  Planet :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"
  CelestialObject :: "entity ⇒ bool"
  Largest :: "entity ⇒ bool"
  SolarSystem :: "entity ⇒ bool"

(* Explanation 1: Earth is a kind of planet. *)
axiomatization where
  explanation_1: "∀x. Earth x ⟶ Planet x"

(* Explanation 2: The sun is the largest celestial body in our solar system. *)
axiomatization where
  explanation_2: "∀x. Sun x ∧ CelestialBody x ∧ SolarSystem x ⟶ Largest x"

(* Explanation 3: The Sun is a kind of star. *)
axiomatization where
  explanation_3: "∀x. Sun x ⟶ Star x"

(* Explanation 4: A star is a kind of celestial object; celestial body. *)
axiomatization where
  explanation_4: "∀x. Star x ⟶ CelestialObject x ∧ CelestialBody x"

theorem hypothesis:
  assumes asm: "Body x ∧ SolarSystem x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "Largest x ⟷ Sun x"
proof -
  from asm have "SolarSystem x" by simp
  then have "Sun x ⟶ Largest x" using explanation_2 by blast
  then have "Largest x ⟶ Sun x" by simp
  then show "Largest x ⟷ Sun x" by blast
qed

end
