theory question_19_0

imports Main

begin

typedecl entity
typedecl event
consts
  Woman :: "entity ⇒ bool"
  PurpleSweater :: "entity ⇒ bool"
  OddLook :: "event ⇒ bool"
  ColorPurple :: "entity ⇒ bool"
  Give :: "event ⇒ entity ⇒ bool"
  LookOnFace :: "event ⇒ entity ⇒ bool"

(* Explanation 1: The color purple gives the woman the look on her face. *)
axiomatization where
  explanation_1: "∀x y. ColorPurple y ⟶ Give y x ∧ LookOnFace x"

theorem hypothesis:
  (* Premise: A woman in a purple sweater has an odd look on her face. *)
  assumes asm: "Woman x ∧ PurpleSweater x ∧ OddLook x"
  (* Hypothesis: A woman in a purple sweater has an odd look on her face. *)
  shows "∃x. Woman x ∧ PurpleSweater x ∧ OddLook x"
proof -
  from asm have "Woman x ∧ PurpleSweater x ∧ OddLook x" by blast
  from explanation_1 have "ColorPurple y ⟶ Give y x ∧ LookOnFace x" by blast
  show ?thesis using `Woman x` `PurpleSweater x` `OddLook x` `ColorPurple y` `Give y x` `LookOnFace x` by blast
qed

end
