theory question_70_0
imports Main

begin

typedecl entity
typedecl event

consts
  Ecosystems :: "entity ⇒ bool"
  Electromagnetism :: "entity ⇒ bool"
  GetEnergy :: "entity ⇒ bool"
  Source :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Most ecosystems get energy from sunlight. *)
axiomatization where
  explanation_1: "∀x e. Ecosystems x ∧ Sunlight e ∧ GetEnergy e ∧ Source e sunlight"

(* Explanation 2: Sunlight is a form of electromagnetic energy. *)
axiomatization where
  explanation_2: "∀x. Sunlight x ⟶ Electromagnetism x"  

theorem hypothesis:
  assumes asm: "Ecosystems x"
  (* Hypothesis: Ecosystems get energy from electromagnetism. *)
  shows "∃x e. Ecosystems x ∧ Electromagnetism e ∧ GetEnergy e ∧ Source e electromagnetism"
proof -
  from asm have "Ecosystems x" by simp
  then obtain e where e: "Sunlight e ∧ GetEnergy e ∧ Source e sunlight" using explanation_1 by blast
  then have "Electromagnetism e" using explanation_2 by blast
  have conclusion: "Sunlight e ∧ GetEnergy e ∧ Source e sunlight" using e by simp
  show ?thesis using asm conclusion `Electromagnetism e` by blast
qed

end
