import seaborn as sn
import pandas as pd
import matplotlib.pyplot as plt
from matplotlib.pyplot import savefig

plt.figure(figsize = (10,7))

# CP
array = [[1.00,-0.22,0.01,-0.19,0.55,-0.05,-0.11,0.24,0.12],
         [-0.22,1.00,-0.55,-0.19,-0.21,-0.63,-0.55,0.49,0.24],
         [0.01,-0.55,1.00,0.24,-0.18,0.73,0.63,-0.54,-0.57],
         [-0.19,-0.19,0.24,1.00,-0.63,0.57,0.12,-0.69,-0.16],
         [0.55,-0.21,-0.18,-0.63,1.00,-0.22,0.01,0.46,-0.19],
         [-0.05,-0.63,0.73,0.57,-0.22,1.00,0.65,-0.81,-0.56],
         [-0.11,-0.55,0.63,0.12,0.01,0.65,1.00,-0.63,-0.74],
         [0.24,0.49,-0.54,-0.69,0.46,-0.81,-0.63,1.00,0.63],
         [0.12,0.24,-0.57,-0.16,-0.19,-0.56,-0.74,0.63,1.00]]

df_cm = pd.DataFrame(array, ['age', 'disability', 'gender', 'nationality', 'appearance', 'race color', 
'religion', 'sex-orient', 'socioecon'], ['age', 'disability', 'gender', 'nationality', 'appearance', 
'race color', 'religion', 'sex-orient', 'socioecon'])
plt.xticks(rotation=60)

# SS
# array = [[1.00,0.71,-0.60,0.88],
#          [0.71,1.00,-0.39,0.87],
#          [-0.60,-0.39,1.00,-0.40],
#          [0.88,0.87,-0.40,1.00]
#          ]

# df_cm = pd.DataFrame(array, ['gender', 'profession', 'race', 'religion'], ['gender', 'profession', 'race', 'religion'])

sn.set(font_scale=1.4) # for label size
sn.heatmap(df_cm, annot=True, annot_kws={"size": 15}, cmap="YlGnBu") # font size

# plt.show()
path = 'results/heatmap-cp-test.png'
savefig(path, dpi=None, facecolor='w', edgecolor='w',
        orientation='portrait',
        transparent=False, bbox_inches='tight', pad_inches=0.1, metadata=None)