import json
import os
import re
import keyword
import ast
from scalpel.cfg import CFGBuilder
import numpy as np


def get_apis(src: str):
    apis = []
    lines = src.split("\n")

    for line in lines:
        line  = line.lstrip()
        if line.startswith("#"):
            continue
        if '=' in line and "(" in line and line.index("=") < line.index("("):
            line = line.split('=', 1)[1].strip()
            api = line.split('(', 1)[0].strip()
            if "\"" not in api and api not in ["print", "input"]:
                apis.append(api)
        elif "(" in line:
            api = line.split('(', 1)[0].strip()
            if not api.startswith("def ") and not api.startswith("if ") and not api.startswith("[") and api not in ["print", "input"]:
                apis.append(api)
    # if len(apis) == 0:
    #     apis = ["no_api"]
    return apis

def get_connected_subsequences(src: str):
    apis = get_apis(src)
    lines = src.split("\n")
    subseq = {}
    for api in apis:
        subseq[api] = []

    for i, line in enumerate(lines):
        line_api = None
        line  = line.strip()            

        if line.endswith("("):
            function_block = ""
            j = i
            while not lines[j].strip().endswith(")"):
                function_block += lines[j]
                j += 1
        else:
            function_block = line

        if line.startswith("#"):
            continue
        if '=' in line and "(" in line and line.index("=") < line.index("("):
            line = line.split('=', 1)[1].strip()
            api = line.split('(', 1)[0].strip()
            if "\"" not in api and api not in ["print", "input"]:
                line_api = api
        elif "(" in line:
            api = line.split('(', 1)[0].strip()
            if not api.startswith("def ") and not api.startswith("if ") and not api.startswith("[") and api not in ["print", "input"]:
                line_api = api
        if line_api is not None:
            for prev_api in apis:
                if prev_api in function_block and prev_api != line_api:
                    subseq[prev_api].append(line_api)


    return subseq


def get_args(code: str):
    try:
        cfg = CFGBuilder().build_from_src(name="top_level", src=code)
    except:
        print("WARNING: CFG build failed!")
        print(code)
        return {}
    args = {}
    lines = code.split("\n")
    blocks = cfg.get_all_blocks()
    for b in blocks:
        for x in b.statements:
            # print(x)
            if isinstance(x, ast.Assign) or isinstance(x, ast.Expr):
                if isinstance(x.value, ast.Call):
                    if not isinstance(x.value.func, ast.Name):
                        continue

                    if x.value.func.id in ["input", "print"]:
                        continue
                    args[x.value.func.id] = {}
                    for k in x.value.keywords:
                        # print(k.value)
                        if isinstance(k.value, ast.Constant):
                            # print(k.value.value)
                            args[x.value.func.id][k.arg] = k.value.value
                        if isinstance(k.value, ast.Attribute):
                            # print(k.arg, k.value.value)
                            s = lines[k.value.value.lineno-1][k.value.value.col_offset:k.value.value.end_col_offset]
                            # obj = s.split(".")[0]
                            
                            args[x.value.func.id][k.arg] = s
                        if isinstance(k.value, ast.List) :
                            # print(k.arg, k.value.value)
                            s = lines[k.value.lineno-1][k.value.col_offset:k.value.end_col_offset]
                            
                            args[x.value.func.id][k.arg] = s

                        if isinstance(k.value, ast.ListComp):
                            # print(k.arg, k.value.value)
                            s = lines[k.value.lineno-1][k.value.col_offset:k.value.end_col_offset]
                            # obj = s.split(".")[0]
                            
                            args[x.value.func.id][k.arg] = s

                        if isinstance(k.value, ast.Subscript):
                            # print(k.arg, k.value.value)
                            s = lines[k.value.lineno-1][k.value.col_offset:k.value.end_col_offset]
                            # obj = s.split(".")[0]
                            
                            args[x.value.func.id][k.arg] = s
                    
                            
            
            if isinstance(x, ast.Call):
                if not isinstance(x.func, ast.Name):
                    continue

                if x.func.id in ["input", "print"]:
                    continue
                args[x.func.id] = {}
                for k in x.keywords:
                    # print(k.value)
                    if isinstance(k.value, ast.Constant):
                        # print(k.value.value)
                        args[x.func.id][k.arg] = k.value.value
                    if isinstance(k.value, ast.Attribute):
                        # print(k.arg, k.value.value)
                        s = lines[k.value.value.lineno-1][k.value.value.col_offset:k.value.value.end_col_offset]
                        # obj = s.split(".")[0]
                        
                        args[x.func.id][k.arg] = s

                    if isinstance(k.value, ast.List):
                        # print(k.arg, k.value.value)
                        s = lines[k.value.lineno-1][k.value.col_offset:k.value.end_col_offset]
                        # obj = s.split(".")[0]
                        
                        args[x.func.id][k.arg] = s

                    if isinstance(k.value, ast.ListComp):
                        # print(k.arg, k.value.value)
                        s = lines[k.value.lineno-1][k.value.col_offset:k.value.end_col_offset]
                        # obj = s.split(".")[0]
                        
                        args[x.func.id][k.arg] = s

    # if args == {}:
    #     print(code)
    # print(args)
    return args
            

def transform(src: str):
    lines = src.split("\n")

    response_obj = {}
    for line in lines:
        line  = line.lstrip()
        if line.startswith("#"):
            continue
        if '=' in line and "(" in line and line.index("=") < line.index("("):
            lhs, rhs = line.split('=', 1)
            lhs = lhs.strip()
            rhs = rhs.strip()
            api = rhs.split('(', 1)[0].strip()
            response_obj[api] = lhs

    new_lines = []
    for line in lines:
        tokens = re.split('(\W)', line)
        for api in response_obj:
            if response_obj[api] in tokens:
                ind = tokens.index(response_obj[api])
                tokens[ind] = "response_" + api
                
        new_lines.append("".join(tokens))
    
    new_src = "\n".join(new_lines)
    
    return new_src



