# Copyright (c) <anonymized for review>

from sqlitedict import SqliteDict
import pickle
from pathlib import Path
from tqdm import tqdm
from argparse import ArgumentParser
import logging

logger = logging.getLogger(__name__)


def main(args):
    p_root_dir = Path(args.root_dir)
    for p_result_file in p_root_dir.glob("**/result.pkl"):
        p_sqlite_file = p_result_file.parent / "result.sqlite"

        if not args.overwrite and p_sqlite_file.is_file():
            logger.info(f"{p_sqlite_file} already exists. Skipping creating a new file.")
            continue

        logger.info(f"Processing {p_result_file}")
        with open(p_result_file, "rb") as f:
            prediction_data = pickle.load(f)

        db = SqliteDict(p_sqlite_file)
        for i, prediction in enumerate(tqdm(prediction_data)):
            db[prediction["uuid"]] = prediction

            if (i + 1) / args.n_commit == 0:
                db.commit()

        db.commit()
        db.close()
        prediction_data = None
        logger.info(f"Dumped results to {p_sqlite_file}")


if __name__ == '__main__':
    logging.basicConfig(level=logging.DEBUG)

    parser = ArgumentParser(description="Dump prediction results to an sqlite dictionary.")
    parser.add_argument("root_dir", help="Root directory")
    parser.add_argument(
        "--overwrite", type=bool, default=False,
        help="Overwrite existing sqlite database files."
    )
    parser.add_argument(
        "--n_commit", type=int, default=1000,
        help="Number of iteration for a commit."
    )
    args = parser.parse_args()

    main(args)
