#!/bin/sh

DATAPATH="classes/wordlists"

mkdir $DATAPATH

for DOMAIN in $(ls classes)
do
    if [[ $DOMAIN == *.txt ]]
    then 
        FNAME=${DOMAIN%.txt}
        cat "classes/$DOMAIN" | xargs cat |\
                                grep -o -E '[a-zA-Z]+' |\
                                tr '[A-Z]' '[a-z]' |\
                                sed '/[0-9_]/d' |\
                                sort | uniq >\
                                "$DATAPATH/wl_${FNAME}.txt"
    fi
done
