# Disentangling Categorization

## Supported environments:
* Linux x86

## Get started
1. Install Anaconda for Linux: https://www.anaconda.com/products/individual#linux
2. Install project dependencies by running `setup.sh` in the project root as:
```
bash -i setup.sh
```
The folder `ProtoPNet` is a clone of https://github.com/cfchen-duke/ProtoPNet. Follow their directions to obtain a copy of the cropped and augmented CUB-200 dataset. 
4. Instantiate the subset of CUB-200 with the `clone_datasets.ipynb` Jupyter notebook in our project root. 

## Experiments

### Configuration files
Scripts rely on `.json` configuration files which hold the hyperparameters for each training run. 

To train a pair of agents given a configuration file at `/path/to/config.json` use:
```
python train_modular.py --config /path/to/config.json --gpuid 0
```

To analyze communication between a pair of agents given a configuration file at `/path/to/config.json` use:
```
python analyze_comms.py --config /path/to/config.json --gpuid 0
```
Note that CUDA support is required.


### Paper results
The anonymized configuration files to re-create results in the paper are stored in `research_pool/config_autogen` under the following sub-directories:
* SEMIOSIS: configuration files for `train_modular.py`

See `research_pool/` directory for more details.




