
# bash run.sh en
# bash run.sh en2de_retran

LG=$1

argslist=""
for (( i = 2; i <= $# ; i++ ))
  do
    j=${!i}
    argslist="${argslist} $j "
  done
echo $argslist >&2

mlsum_prefix=hdfs://haruna/home/byte_arnold_hl_mlnlc/user/wuxianze.0/Datasets/multilingual/mlsum
data_path=${mlsum_prefix}/${LG}
embedding_path=${mlsum_prefix}/embeddings/${LG}

local_root=~/embed_cls_${LG}
local_dataset=${local_root}/dataset

if [ ! -e ${local_dataset} ]; then
    mkdir -p ${local_dataset}
fi

if [ ! -e ${local_dataset}/document.jsonl ]; then
    hdfs dfs -get ${data_path}/test.${LG}.label.jsonl ${local_dataset}/document.jsonl
fi

if [ ! -e ${local_dataset}/sent_embedding.jsonl ]; then
    hdfs dfs -get ${embedding_path}/sent_embedding.jsonl ${local_dataset}/
fi

python3 main.py -i ${local_dataset} $argslist >&1
