import pandas as pd
import matplotlib.pyplot as plt
import numpy as np

filename1 = "/home/LayerDrop/models/may14/vanilla_bart_base_3e-5/eval-dev-performance.csv"
filename2 = "/home/LayerDrop/models/may13/routing_randomTaskemb_lstm/best/eval-dev-performance.csv"

df1 = pd.read_csv(filename1, index_col=0)
df1 = df1.rename(columns={"performance": "model1_performance"})
df2 = pd.read_csv(filename2, index_col=0)
df2 = df2.rename(columns={"performance": "model2_performance"})

df = df1.merge(df2)
df["diff"] = df["model2_performance"] - df["model1_performance"]
df = df.sort_values(by=['diff'])
print(df.head())

fig, ax = plt.subplots(figsize=(10, 20))
y_pos = np.arange(len(df))
ax.barh(y_pos, df["diff"], align="center")
ax.set_yticks(y_pos)
ax.set_yticklabels(df["task_prefix"])
plt.subplots_adjust(left=0.4)
plt.savefig("figure_dev.png")
