# Progressive Transformers

`cd ProgressiveTransformersSLP`

## Install 
Install required packages using the requirements.txt file.

`pip install -r requirements.txt`

## Usage

To run, start __main__.py with arguments "train" and ".\Configs\Base.yaml":

`python __main__.py train ./Configs/Base.yaml` 

You need ot modify the yaml file.

(1) You need to have the Original PT dataset (I used the one Sabit shared)

(2) copy the augmented glosses files into their corresponding folders.

(3) regenerate the vocabulary (since we have augmented glosses) by running `make_new_vocabulary.py` , pay attention that you need to modify the train_path in line 3.

(4) in Base.yaml, make sureyou have the correct src_vocab and data:src was set to "gloss".



### Dump the skeletons

First call the below function in `training.py` main function.

`test(cfg_file=PATH_OF_MODEL_CONFIG_FILE, ckpt=get_latest_checkpoint( PATH_OF_TRAINED_MODEL,post_fix="_best"))

Then `python training.py` 

### Convert Data to SLT format.

`python write_file_slt.py --cur_path Data/MODEL_SKELETON_NAME`


# SLT

Make sure you have the corresponding data.

`cd slt`

`pip install -r requirements.txt`

## Training
`python -m signjoey test configs/YOUR_MODIFIED_YAML`
you only need to modify the data:data_path in the YAML file.

## Test
`python -m signjoey test configs/YOUR_MODIFIED_YAML --ckpt best_carla.ckpt --output_path output/MODEL_NAME`


