dataset_defaults = {
    'ecthr': {
        'split_scheme': 'official',
        'model': 'legal-longformer',
        'train_transform': 'bert',
        'eval_transform': 'bert',
        'max_token_length': 4096,
        'loss_function': 'binary_cross_entropy',
        'algo_log_metric': 'multi-label-f1',
        'val_metric': 'F1-micro_all',
        'batch_size': 32,
        'lr': 2e-5,
        'weight_decay': 0.01,
        'n_epochs': 20,
        'n_groups_per_batch': 8,
        'groupby_fields': ['defendant'],
        'irm_lambda': 0.5,
        'coral_penalty_weight': 0.1,
        'adv_lambda': 0.1,
        'val_metric_decreasing': False,
        'loader_kwargs': {
            'num_workers': 0,
            'pin_memory': True,
        }
    },
    'eurlex': {
        'split_scheme': 'official',
        'model': 'nlpaueb/legal-bert-small-uncased',
        'train_transform': 'bert',
        'eval_transform': 'bert',
        'max_token_length': 512,
        'loss_function': 'binary_cross_entropy',
        'algo_log_metric': 'multi-label-f1',
        'val_metric': 'F1-micro_all',
        'batch_size': 64,
        'lr': 2e-5,
        'weight_decay': 0.01,
        'n_epochs': 20,
        'n_groups_per_batch': 8,
        'groupby_fields': ['defendant'],
        'irm_lambda': 0.5,
        'coral_penalty_weight': 0.1,
        'adv_lambda': 0.1,
        'val_metric_decreasing': False,
        'loader_kwargs': {
            'num_workers': 0,
            'pin_memory': True,
        }
    },
    'eurlex100': {
        'split_scheme': 'official',
        'model': 'lwan/nlpaueb/legal-bert-small-uncased',
        'train_transform': 'bert',
        'eval_transform': 'bert',
        'max_token_length': 512,
        'loss_function': 'binary_cross_entropy',
        'algo_log_metric': 'multi-label-f1',
        'val_metric': 'F1-micro_all',
        'batch_size': 64,
        'lr': 2e-5,
        'weight_decay': 0.01,
        'n_epochs': 50,
        'n_groups_per_batch': 16,
        'groupby_fields': ['defendant'],
        'irm_lambda': 0.5,
        'coral_penalty_weight': 0.1,
        'adv_lambda': 0.1,
        'val_metric_decreasing': False,
        'loader_kwargs': {
            'num_workers': 0,
            'pin_memory': True,
        }
    },
    'eurlex500': {
        'split_scheme': 'official',
        'model': 'lwan/nlpaueb/legal-bert-small-uncased',
        'train_transform': 'bert',
        'eval_transform': 'bert',
        'max_token_length': 512,
        'loss_function': 'binary_cross_entropy',
        'algo_log_metric': 'multi-label-f1',
        'val_metric': 'F1-micro_all',
        'batch_size': 64,
        'lr': 2e-5,
        'weight_decay': 0.01,
        'n_epochs': 50,
        'n_groups_per_batch': 16,
        'groupby_fields': ['defendant'],
        'irm_lambda': 0.1,
        'sd_lambda': 0.1,
        'coral_penalty_weight': 0.1,
        'adv_lambda': 0.1,
        'val_metric_decreasing': False,
        'loader_kwargs': {
            'num_workers': 0,
            'pin_memory': True,
        }
    },
    'prachathai': {
            'split_scheme': 'official',
            'model': 'xlm-roberta-base',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 8,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
        'uk_legislation': {
            'split_scheme': 'official',
            'model': 'nlpaueb/legal-bert-small-uncased',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 8,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
        'uk_legislation40': {
            'split_scheme': 'official',
            'model': 'nlpaueb/legal-bert-small-uncased',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 16,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
        'bioasq16': {
            'split_scheme': 'official',
            'model': 'google/bert_uncased_L-6_H-512_A-8',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 8,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
        'bioasq116': {
            'split_scheme': 'official',
            'model': 'google/bert_uncased_L-6_H-512_A-8',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 16,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
        'mimic20': {
            'split_scheme': 'official',
            'model': 'google/bert_uncased_L-6_H-512_A-8',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 16,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
    'mimic200': {
            'split_scheme': 'official',
            'model': 'google/bert_uncased_L-6_H-512_A-8',
            'train_transform': 'bert',
            'eval_transform': 'bert',
            'max_token_length': 512,
            'loss_function': 'binary_cross_entropy',
            'algo_log_metric': 'multi-label-f1',
            'val_metric': 'F1-micro_all',
            'batch_size': 64,
            'lr': 2e-5,
            'weight_decay': 0.01,
            'n_epochs': 20,
            'n_groups_per_batch': 16,
            'groupby_fields': ['defendant'],
            'irm_lambda': 0.5,
            'coral_penalty_weight': 0.1,
            'adv_lambda': 0.1,
            'val_metric_decreasing': False,
            'loader_kwargs': {
                'num_workers': 0,
                'pin_memory': True,
            }
        },
}
