import joblib
import os
import numpy as np


def test(path, K=100):
   targets, predes, spans = joblib.load(path)
   N = len(predes)
   M = N // K
   pred = [[jj[:-1] for jj in ii] for ii in predes]
   res = [cacl_f1(targets[M * ii:M * (ii + 1)], pred[ii * M:(ii + 1) * M]) for ii in range(K)]
   p, r, f = np.mean(res, 0)
   pred = [[jj[:-1] for jj in ii if jj[-1] > 2.5] for ii in predes]
   res = [cacl_f1(targets[M * ii:M * (ii + 1)], pred[ii * M:(ii + 1) * M]) for ii in range(K)]
   p1, r1, f1 = np.mean(res, 0)
   print(f"{p*100:.3f},{r*100:.3f},{f*100:.3f},{p1*100:.3f},{r1*100:.3f},{f1*100:.3f}")

def cacl_f1(targets: list, predes: list):
    tp, fp, fn = 0, 0, 0
    for ii, jj in zip(targets, predes):
        ii, jj = set(ii), set(jj)
        same = ii - (ii - jj)
        tp += len(same)
        fn += len(ii - jj)
        fp += len(jj - ii)
    p = tp / (fp + tp + 1e-10)
    r = tp / (fn + tp + 1e-10)
    return  p, r, 2 * p * r / (p + r + 1e-10)

for ii in [667, 171, 354, 550, 985]:
    path1 = path.replace("171", str(ii))
    if not os.path.exists(path1):
        continue
    test(path1, T)