# Pneg: Prompt-based Negative Response Generation for Robust Response Selection Model

In retrieval-based dialogue systems, a response selection model acts as a ranker to select the most appropriate response among several candidates. However, such selection models tend to rely on context-response content similarity, which makes models vulnerable to adversarial responses that are semantically similar but not relevant to the dialogue context. Recent studies have shown that leveraging these adversarial responses as negative training samples is useful for improving the discriminating power of the selection model.
Nevertheless, collecting human-written adversarial responses is expensive, and existing synthesizing methods often have limited scalability. To overcome these limitations, this paper proposes a simple but efficient method for generating adversarial negative responses leveraging a large-scale language model. Experimental results on dialogue selection tasks show that our method outperforms other methods of synthesizing adversarial negative responses. These results suggest that our method can be an effective alternative to human annotators in generating adversarial responses. Our code and dataset will be released if the paper is accepted.

## Code Details

we provide three script sets, **negative_generation**, **response_selection**, and **response_evaluation**.

With **negative_generation** source code, you can generate adversarial negative responses with open API of GPT3
With **response_selection** source code and **run_train/inference** script, you can train and evaluate the response selection models on dialogue response selection task using adversarial negative responses from our Pneg.

The training and testing script examples are provided in **scripts/** folder.
