"""RoBERTa configuration."""

from transformers.models.roberta import RobertaConfig 

class RobertaConfig(RobertaConfig):
    def __init__(self,
        # clutering parameters.
        clustering_logits_projection=None,
        verbalizer_pooling_type="mean",
        input_pooling_type="last",
        centroids_type="verbalizers_embd", 
        clustering_loss=None,
        verbalizer_ensemble=False,
        weights_activation="sigmoid",
        verbalizer_embd_type="embd",
        init_centroids=False,  
        assignment_regularization=None,
        assignment_regularization_weight=1e-2,
        hinge_p = 1,
        hinge_margin = 1,
        use_masks_embeddings=True,
        soft_pet=False,
        soft_pet_aggregation=None,
        soft_pet_temperature=1.0,
        extra_tokens_init="tokens",
        extra_without_original=True,
        model_name_or_path=None,
        train_in_batch=False,
        extra_embd_initializer_range=0.02,
        token_classifier = False,
        token_hinge_loss=False,
        multiclass_ce_loss=False,
        prompt_tune=False,
        prompt_length=20,
        init_prompt_from_vocab = True,
        prompt_init_range = 1e-4, 
        **kwargs):
        super().__init__(**kwargs)
        # Clustering parameters.
        self.clustering_logits_projection = clustering_logits_projection
        self.verbalizer_pooling_type = verbalizer_pooling_type
        self.input_pooling_type = input_pooling_type
        self.centroids_type = centroids_type 
        self.clustering_loss = clustering_loss 
        self.verbalizer_ensemble = verbalizer_ensemble
        self.weights_activation = weights_activation
        self.init_centroids = init_centroids   
        self.verbalizer_embd_type = verbalizer_embd_type 
        self.assignment_regularization=assignment_regularization
        self.assignment_regularization_weight=assignment_regularization_weight
        self.hinge_p = hinge_p 
        self.hinge_margin = hinge_margin 
        self.use_masks_embeddings = use_masks_embeddings
        self.soft_pet = soft_pet
        self.soft_pet_aggregation = soft_pet_aggregation
        self.soft_pet_temperature = soft_pet_temperature
        self.extra_tokens_init = extra_tokens_init
        self.extra_without_original = extra_without_original
        self.model_name_or_path=model_name_or_path
        self.train_in_batch=train_in_batch
        self.extra_embd_initializer_range=extra_embd_initializer_range
        self.token_classifier = token_classifier 
        self.token_hinge_loss = token_hinge_loss
        self.multiclass_ce_loss = multiclass_ce_loss
        self.prompt_tune = prompt_tune 
        self.prompt_length = prompt_length
        self.init_prompt_from_vocab = init_prompt_from_vocab
        self.prompt_init_range = prompt_init_range
