"""Implements the adapter's configuration."""
from dataclasses import dataclass 

@dataclass
class AdapterConfig(object):
    """Implements the adapter configuration proposed by Houlsby et. al, 2019
    in https://arxiv.org/abs/1902.00751."""
    # This is for the layernorms applied after feedforward/self-attention layers.
    add_layer_norm_before_adapter: bool = False  
    add_layer_norm_after_adapter: bool = False 
    # This is for the layernorms applied to the query and key values.
    add_layer_norm_after_adapter_attn = False 
    add_layer_norm_before_adapter_attn = False 
    nonlinearity: str = "gelu_new"
    reduction_factor: int = 16
    attn_reduction_factor: int = 16
    # If specified adds adapters to key and query of the self-attention.
    key_tune: bool = False 
    query_tune: bool = False 
    value_tune: bool = False 
    # In case using adapters for QKV, we can decide to remove the upsampling part.
    remove_attn_upsampling: bool = False 
    # By default, we add adapters after attention, set False if otherwise.
    add_adapter_after_attention = True
    add_adapter_after_feedforward = True
    # Trains the adapters if this is set to true.
    adapter_tune = False   
