LANGUAGE=$1
DATA_TYPE=$2
CHECKPOINT1=$3
CHECKPOINT2=$4
DEVICE=$5

## First 2 lines are constant for a LANGUAGE. Therfore run them only once
# python make_test_s1.py --lang ${LANGUAGE}
# bash preprocess_test.sh ${LANGUAGE} gen2oie_s1 

bash generate_openie.sh ${LANGUAGE} gen2oie_s1 ${DATA_TYPE} ${CHECKPOINT1} ${DEVICE}
python make_test_s2.py --lang ${LANGUAGE} --data_type ${DATA_TYPE}
bash preprocess_test.sh ${LANGUAGE} gen2oie_s2  ${DATA_TYPE}
bash generate_openie.sh ${LANGUAGE} gen2oie_s2 ${DATA_TYPE} ${CHECKPOINT2} ${DEVICE}

python postprocess_scores.py --lang ${LANGUAGE} --model_type gen2oie_s2 --data_type ${DATA_TYPE}
bash generate_scores.sh ${LANGUAGE} gen2oie_s2 ${DATA_TYPE} ${CHECKPOINT2} ${DEVICE}
python create_allennlp.py --lang ${LANGUAGE} --model_type gen2oie_s2 --data_type ${DATA_TYPE}
python carb/carb.py --allennlp ../models/${LANGUAGE}/gen2oie_s2/${DATA_TYPE}-data/test.predicted.allennlp  --gold carb/data/gold/${LANGUAGE}_test.tsv --out /dev/null

# bash gen2oie_test.sh zh ctranslate_clp_no_pos_tags;  bash gen2oie_test.sh zh ctranslate_clp_no_verb_removal; bash gen2oie_test.sh zh ctranslate_clp_rand_sort; bash gen2oie_test.sh hi ctranslate_clp_no_verb_removal; bash gen2oie_test.sh hi ctranslate_clp_rand_sort
# bash train.sh pt_genoie_ctranslate_clp node-1 50000; bash train.sh pt_genoie_translate_clp node-1 50000; bash train.sh pt_genoie_clp node-1 50000; bash train.sh pt_gen2oie_s1_translate_clp node-1 50000; bash train.sh pt_gen2oie_s2_translate_clp node-1 50000
# bash train.sh te_gen2oie_s1_translate_clp node-2 25000; bash train.sh te_gen2oie_s2_translate_clp node-2 25000; bash train.sh te_gen2oie_s1_clp node-2 25000; bash train.sh te_gen2oie_s2_clp node-2 25000  
