import json
import time
from num2words import num2words
from word2number import w2n
from nltk.tokenize import word_tokenize




def write_json(data,json_file):
    with open(json_file, "w") as f:
        json.dump(data, f, indent=2, ensure_ascii=False)
        

def create_data(template_name,translated_file,target_language,dictionary_file,output_file):
    template_file = template_name+'.json'
    with open(template_file, "r") as f:
        template = json.load(f)

    
    with open(translated_file, "r") as f:
        list_translated_corrected = f.readlines()
    sentence_count = 0

    for data in template:

        for i in range(len(template[data]['log'])):
            template[data]['log'][i]['text']=list_translated_corrected[sentence_count].replace('\n','')
            sentence_count = sentence_count+1
            if sentence_count == len(list_translated_corrected):
                sentence_count = 0
    print(len(template))
    target_template = template_name+"-"+target_language+'.json'
    with open(target_template, "w") as of:
        json.dump(template, of, indent=2, ensure_ascii=False)
    
    with open(dictionary_file, "r") as f:
        dictionary = json.load(f)

    
    for dic in dictionary:
        for key in dictionary[dic].keys():
            if isinstance(dictionary[dic][key],int):
                dictionary[dic][key] = str(dictionary[dic][key])
    #             print(type(dictionary_chinese[data][key]))
    
    for data in template:
        dictionary_tgt = dictionary[data]
    #print(dictionary)
        for key, value in dictionary_tgt.items():
            for i in range(len(template[data]['log'])):
                if key in template[data]['log'][i]['text']:
                    text = template[data]['log'][i]['text']
                    if target_language in {'zh','ja'}:
                        text = text.replace(" ","")
                    text = text.replace(key,value)
                    template[data]['log'][i]['text']=text

                for act in template[data]['log'][i]['dialog_act'].keys():
                    for j in range(len(template[data]['log'][i]['dialog_act'][act])):
                        for k in range(len(template[data]['log'][i]['dialog_act'][act][j])):
                            text = template[data]['log'][i]['dialog_act'][act][j][k]
                            text = text.replace(key,value)
                            template[data]['log'][i]['dialog_act'][act][j][k] = text

                if len(template[data]['log'][i]['span_info']) > 0:
                    for j in range(len(template[data]['log'][i]['span_info'])):
                        for k in range(len(template[data]['log'][i]['span_info'][j])):
                            text = template[data]['log'][i]['span_info'][j][k]
                            try:
                                text = text.replace(key,value)
                            except:
                                pass
                            template[data]['log'][i]['span_info'][j][k] = text

                for meta in template[data]['log'][i]['metadata'].keys():
                    for semi_2 in template[data]['log'][i]['metadata'][meta]['semi'].keys():
                        for j in range(len(template[data]['log'][i]['metadata'][meta]['semi'][semi_2])):
                            text = template[data]['log'][i]['metadata'][meta]['semi'][semi_2][j]
                            text = text.replace(key,value)
                            template[data]['log'][i]['metadata'][meta]['semi'][semi_2][j] = text
                    for book_2 in template[data]['log'][i]['metadata'][meta]['book']:
                        for j in range(len(template[data]['log'][i]['metadata'][meta]['book'][book_2])):
                            if isinstance(template[data]['log'][i]['metadata'][meta]['book'][book_2][j],dict):
                                for k,v in template[data]['log'][i]['metadata'][meta]['book'][book_2][j].items():
                                    if isinstance(template[data]['log'][i]['metadata'][meta]['book'][book_2][j][k],list):
                                        for l in range(len(template[data]['log'][i]['metadata'][meta]['book'][book_2][j][k])):
                                            text =  template[data]['log'][i]['metadata'][meta]['book'][book_2][j][k][l]
                                            text = text.replace(key,value)
                                            template[data]['log'][i]['metadata'][meta]['book'][book_2][j][k][l] = text
                                    else:
                                        text = template[data]['log'][i]['metadata'][meta]['book'][book_2][j][k]
                                        text = text.replace(key,value)
                                        template[data]['log'][i]['metadata'][meta]['book'][book_2][j][k] = text

                            else:
                                text = template[data]['log'][i]['metadata'][meta]['book'][book_2][j]
                                text = text.replace(key,value)
                                template[data]['log'][i]['metadata'][meta]['book'][book_2][j] = text


            for goal in template[data]['goal']:
                for goal_2 in template[data]['goal'][goal]:
                    if isinstance(template[data]['goal'][goal][goal_2],dict):
                        for goal_3 in template[data]['goal'][goal][goal_2].keys():
                            text = template[data]['goal'][goal][goal_2][goal_3]
                            try:
                                text = text.replace(key,value)
                            except:
                                pass
                            template[data]['goal'][goal][goal_2][goal_3] = text
        
    with open(output_file, "w") as of:
        json.dump(template, of, indent=2, sort_keys=True, ensure_ascii=False)
        
                
