#!/usr/bin/env bash

cd ..
export PYTHONPATH="$(pwd)"

python Models/Tune_Eval_NLI.py \
    model_setup.model_name="roberta-large-mnli" \
    +nli_module_class='NLIModule' \
    model_setup.tuned_model_path="/nas/home/qasemi/CQplus/Outputs/ModifiedLangModeling/Checkpoint/ModifiedLMModule.ckpt" \
    data_module.train_composition=[anion] \
    data_module.test_composition=[dnli] \
    +weakcq_recal_threshold=0.90 \
    +n_anion_samples=50000 \
    +n_winoventi_samples=50000 \
    +n_mnli_samples=10000 \
    data_module.overwrite_cache=true \
    data_module.use_class_weights=true \
    train_setup.do_train=true \
    hardware.gpus="0" \
    train_setup.max_epochs=5 \
    train_setup.batch_size=64 \
    +no_hyper_tune=true \
    hydra.run.dir="/nas/home/qasemi/CQplus/Outputs/Tune_Eval_NLI/test"
