import random, os
from sklearn.metrics import accuracy_score, f1_score

INFO_PATH = "./data_with_feat/txt/test"
PROB_MAP = {"disstat": "first_mention.txt", "syn": "syntax.txt", "distant": "sent_dist_3_bins.txt", "intref": "same_prev_mention.txt",
            "glosal": "salience_quantile.txt", "locsal": "prominent_referent.txt", "focus": "focus.txt", "senstat": "same_sent_ante.txt"}

def read_data(file_name):
    data = [i.strip() for i in open(file_name).readlines()]
    return data

def cls_map(prob_task, label):
    if prob_task in ["disstat", "syn", "focus"]:
        CLS_MAP = {"yes": 1, "no": 0, "np-subj": 0, "np-obj": 1, "subj-det": 0}
    elif prob_task == "distant":
        CLS_MAP = {"first_mention": 0, "bin_1": 1, "bin_2": 2, "bin_3": 3}
    elif prob_task in ["intref", "senstat"]:
        CLS_MAP = {"yes": 2, "no": 1, "first_mention": 0}
    elif prob_task == "glosal":
        CLS_MAP = {"bin_1": 0, "bin_2": 1, "bin_3": 2, "bin_4": 3}
    elif prob_task == "locsal":
        CLS_MAP = {"yes": 1, "no": 0}
    return CLS_MAP[label]

def run(file_name, task):
    data = read_data(file_name)
    data = [cls_map(task, i) for i in data]
    label = list(set(data))
    f1, acc = 0.0, 0.0
    for i in range(5):
        predicted = []
        for sample in data:
            predicted.append(random.choice(label))
        f1 += f1_score(data, predicted, average='macro')
        acc += accuracy_score(data, predicted)
    print(task, acc/5, f1/5)

for task in PROB_MAP:
    run(os.path.join(INFO_PATH, PROB_MAP[task]), task)