/*
 * Decompiled with CFR 0.152.
 */
package annotation_scorers;

import annotation_scorers.Judgement;
import annotation_scorers.Scomp;
import annotation_scorers.Score;
import java.io.BufferedReader;
import java.io.FileReader;
import nlp_files.PipesFile;

public class Scorer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Score score(PipesFile annot, String key, int elembiocol, int attrscol) {
        Score score = null;
        int numline = 0;
        try {
            String annotline;
            String keyline;
            BufferedReader keyreader = new BufferedReader(new FileReader(key));
            BufferedReader annotreader = new BufferedReader(new FileReader(annot.getFile()));
            score = new Score(key, annot.getFile().getCanonicalPath());
            Judgement keyjudgement = null;
            Judgement annotjudgement = null;
            while ((keyline = keyreader.readLine()) != null) {
                ++numline;
                annotline = annotreader.readLine();
                if (annotline == null) {
                    throw new Exception("Scored annotation ended before key annotation");
                }
                if (keyline.equals("|")) {
                    if (!annotline.equals("|")) throw new Exception("Unaligned sentences in: annotation and key files");
                    if (annotjudgement != null) {
                        score.add(annotjudgement);
                        annotjudgement = null;
                    }
                    if (keyjudgement == null) continue;
                    score.add(keyjudgement);
                    keyjudgement = null;
                    continue;
                }
                String[] keyarr = keyline.split("\\|");
                String[] annotarr = annotline.split("\\|");
                if (keyarr.length < annot.getPipesDescArrCount() || annotarr.length < annot.getPipesDescArrCount()) {
                    System.err.println("Malformed pipesFile line: Has less columns than description file");
                    elembiocol = keyarr.length - 1;
                    attrscol = -1;
                }
                if (!annotarr[elembiocol].equals("O") && annotarr[elembiocol].length() < 3 || !keyarr[elembiocol].equals("O") && keyarr[elembiocol].length() < 3) {
                    System.err.println("Malformed BIO format: " + annotarr[elembiocol]);
                }
                if (!annotarr[elembiocol].equals("O")) {
                    String annotelement = annotarr[elembiocol].substring(2);
                    if (annotarr[elembiocol].startsWith("B-")) {
                        String annotattrs = "";
                        if (attrscol != -1) {
                            annotattrs = annotarr[attrscol];
                        }
                        if (annotjudgement != null) {
                            score.add(annotjudgement);
                            annotjudgement = null;
                        }
                        if (keyjudgement == null || keyjudgement.isAligned().booleanValue()) {
                            annotjudgement = new Judgement(Judgement.judgements.valueOf("spur").ordinal(), annotelement, annotattrs, numline, keyline, annotline);
                            if (keyjudgement != null && keyarr[elembiocol].startsWith("I-") && keyjudgement.getJudgement_str().equals("corr")) {
                                keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                            }
                        } else if (annotelement.equals(keyjudgement.getElement()) && keyarr[elembiocol].startsWith("I-")) {
                            keyjudgement.add_alt_attribs(annotattrs, "annot");
                            keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                        } else {
                            annotjudgement = new Judgement(Judgement.judgements.valueOf("spur").ordinal(), annotelement, annotattrs, numline, keyline, annotline);
                        }
                    } else {
                        if (!annotarr[elembiocol].startsWith("I-")) throw new Exception("Malformed BIO format: " + annotarr[elembiocol]);
                        if (annotjudgement != null) {
                            if (!annotjudgement.getElement().equals(annotelement)) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + annotjudgement.getElement());
                            annotjudgement.extendJudgement(keyline, annotline);
                        } else {
                            if (keyjudgement == null) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected O");
                            if (!keyjudgement.getElement().equals(annotelement) || !keyjudgement.isAligned().booleanValue()) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + keyjudgement.getElement());
                            if (keyarr[elembiocol].startsWith("B-")) {
                                keyjudgement.changeAndExtendJudgement(Judgement.judgements.valueOf("inco").ordinal(), keyline, annotline);
                            } else {
                                keyjudgement.extendJudgement(keyline, annotline);
                            }
                            annotjudgement = keyjudgement;
                            keyjudgement = null;
                        }
                    }
                } else {
                    if (annotjudgement != null) {
                        score.add(annotjudgement);
                        annotjudgement = null;
                    }
                    if (keyjudgement != null && keyjudgement.isAligned().booleanValue()) {
                        if (keyarr[elembiocol].startsWith("I-") && keyjudgement.getJudgement_str().equals("corr")) {
                            keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                        }
                        annotjudgement = keyjudgement;
                        keyjudgement = null;
                    }
                }
                if (!keyarr[elembiocol].equals("O")) {
                    String keyelement = keyarr[elembiocol].substring(2);
                    if (keyarr[elembiocol].startsWith("B-")) {
                        String keyattrs = "";
                        if (attrscol != -1) {
                            keyattrs = keyarr[attrscol];
                        }
                        if (keyjudgement != null) {
                            score.add(keyjudgement);
                            keyjudgement = null;
                        }
                        if (annotjudgement == null || annotjudgement.isAligned().booleanValue()) {
                            keyjudgement = new Judgement(Judgement.judgements.valueOf("miss").ordinal(), keyelement, keyattrs, numline, keyline, annotline);
                        } else if (keyelement.equals(annotjudgement.getElement())) {
                            annotjudgement.add_alt_attribs(keyattrs, "key");
                            if (annotarr[elembiocol].startsWith("B-")) {
                                annotjudgement.changeJudgement(Judgement.judgements.valueOf("corr").ordinal());
                            } else {
                                annotjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                                annotjudgement.updateNumline(numline);
                            }
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                        } else {
                            keyjudgement = new Judgement(Judgement.judgements.valueOf("miss").ordinal(), keyelement, keyattrs, numline, keyline, annotline);
                        }
                    } else {
                        if (!keyarr[elembiocol].startsWith("I-")) throw new Exception("Malformed BIO format: " + annotarr[elembiocol]);
                        if (keyjudgement != null) {
                            if (!keyjudgement.getElement().equals(keyelement)) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + annotjudgement.getElement());
                            keyjudgement.extendJudgement(keyline, annotline);
                        } else {
                            if (annotjudgement == null) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected O");
                            if (!annotjudgement.getElement().equals(keyelement) || !annotjudgement.isAligned().booleanValue()) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + keyjudgement.getElement());
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                        }
                    }
                } else {
                    if (keyjudgement != null) {
                        score.add(keyjudgement);
                        keyjudgement = null;
                    }
                    if (annotjudgement != null && annotjudgement.isAligned().booleanValue()) {
                        if (annotarr[elembiocol].startsWith("I-") && annotjudgement.getJudgement_str().equals("corr")) {
                            annotjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                        } else if (annotarr[elembiocol].equals("O")) {
                            score.add(annotjudgement);
                            annotjudgement = null;
                        }
                    }
                }
                if (keyarr[elembiocol].equals("O")) {
                    if (annotarr[elembiocol].equals("O")) {
                        score.addtn();
                        continue;
                    }
                    String aelem = annotarr[elembiocol].substring(2);
                    score.addfp(aelem);
                    score.addtnrest(aelem);
                    continue;
                }
                String kelem = keyarr[elembiocol].substring(2);
                if (annotarr[elembiocol].equals("O")) {
                    score.addfn(kelem);
                    score.addtnrest(kelem);
                    continue;
                }
                String aelem = annotarr[elembiocol].substring(2);
                if (kelem.equals(aelem)) {
                    score.addtp(kelem);
                    score.addtnrest(aelem);
                    continue;
                }
                score.addfn(kelem);
                score.addfp(aelem);
            }
            annotline = annotreader.readLine();
            if (annotline != null) {
                throw new Exception("Key annotation ended before scored annotation");
            }
        }
        catch (Exception e) {
            System.err.println("\nErrors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + " (line " + numline + ")\n");
            if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) return null;
            e.printStackTrace(System.err);
            System.exit(1);
            return null;
        }
        if (score == null) return score;
        score.sort_judgements_by_numline();
        return score;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Score score_recclass(PipesFile annot, String key, int elembiocol, int attrscol) {
        Score score = null;
        int numline = 0;
        try {
            String annotline;
            String keyline;
            BufferedReader keyreader = new BufferedReader(new FileReader(key));
            BufferedReader annotreader = new BufferedReader(new FileReader(annot.getFile()));
            score = new Score(key, annot.getFile().getCanonicalPath());
            Judgement keyjudgement = null;
            Judgement annotjudgement = null;
            while ((keyline = keyreader.readLine()) != null) {
                ++numline;
                annotline = annotreader.readLine();
                if (annotline == null) {
                    throw new Exception("Scored annotation ended before key annotation");
                }
                if (keyline.equals("|")) {
                    if (!annotline.equals("|")) throw new Exception("Unaligned sentences in: annotation and key files");
                    if (annotjudgement != null) {
                        score.add(annotjudgement);
                        annotjudgement = null;
                    }
                    if (keyjudgement == null) continue;
                    score.add(keyjudgement);
                    keyjudgement = null;
                    continue;
                }
                String[] keyarr = keyline.split("\\|");
                String[] annotarr = annotline.split("\\|");
                if (keyarr.length < annot.getPipesDescArrCount() || annotarr.length < annot.getPipesDescArrCount()) {
                    System.err.println("Malformed pipesFile line: Has less columns than description file");
                    elembiocol = keyarr.length - 1;
                    attrscol = -1;
                }
                if (!annotarr[elembiocol].equals("O") && annotarr[elembiocol].length() < 3 || !keyarr[elembiocol].equals("O") && keyarr[elembiocol].length() < 3) {
                    System.err.println("Malformed BIO format: " + annotarr[elembiocol]);
                }
                if (!annotarr[elembiocol].equals("O")) {
                    String annotelement = annotarr[elembiocol].substring(2).split("-")[0];
                    if (annotarr[elembiocol].startsWith("B-")) {
                        String annotattrs = "class=\"" + annotarr[elembiocol].substring(2).split("-")[1] + "\"";
                        if (annotjudgement != null) {
                            score.add(annotjudgement);
                            annotjudgement = null;
                        }
                        if (keyjudgement == null || keyjudgement.isAligned().booleanValue()) {
                            annotjudgement = new Judgement(Judgement.judgements.valueOf("spur").ordinal(), annotelement, annotattrs, numline, keyline, annotline);
                            if (keyjudgement != null && keyarr[elembiocol].startsWith("I-") && keyjudgement.getJudgement_str().equals("corr")) {
                                keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                            }
                        } else if (annotelement.equals(keyjudgement.getElement()) && keyarr[elembiocol].startsWith("I-")) {
                            keyjudgement.add_alt_attribs(annotattrs, "annot");
                            keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                        } else {
                            annotjudgement = new Judgement(Judgement.judgements.valueOf("spur").ordinal(), annotelement, annotattrs, numline, keyline, annotline);
                        }
                    } else {
                        if (!annotarr[elembiocol].startsWith("I-")) throw new Exception("Malformed BIO format: " + annotarr[elembiocol]);
                        if (annotjudgement != null) {
                            if (!annotjudgement.getElement().equals(annotelement)) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + annotjudgement.getElement());
                            annotjudgement.extendJudgement(keyline, annotline);
                        } else {
                            if (keyjudgement == null) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected O");
                            if (!keyjudgement.getElement().equals(annotelement) || !keyjudgement.isAligned().booleanValue()) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + keyjudgement.getElement());
                            if (keyarr[elembiocol].startsWith("B-")) {
                                keyjudgement.changeAndExtendJudgement(Judgement.judgements.valueOf("inco").ordinal(), keyline, annotline);
                            } else {
                                keyjudgement.extendJudgement(keyline, annotline);
                            }
                            annotjudgement = keyjudgement;
                            keyjudgement = null;
                        }
                    }
                } else {
                    if (annotjudgement != null) {
                        score.add(annotjudgement);
                        annotjudgement = null;
                    }
                    if (keyjudgement != null && keyjudgement.isAligned().booleanValue()) {
                        if (keyarr[elembiocol].startsWith("I-") && keyjudgement.getJudgement_str().equals("corr")) {
                            keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                        }
                        annotjudgement = keyjudgement;
                        keyjudgement = null;
                    }
                }
                if (!keyarr[elembiocol].equals("O")) {
                    String keyelement = keyarr[elembiocol].substring(2).split("-")[0];
                    if (keyarr[elembiocol].startsWith("B-")) {
                        String keyattrs = "class=\"" + keyarr[elembiocol].substring(2).split("-")[1] + "\"";
                        if (keyjudgement != null) {
                            score.add(keyjudgement);
                            keyjudgement = null;
                        }
                        if (annotjudgement == null || annotjudgement.isAligned().booleanValue()) {
                            keyjudgement = new Judgement(Judgement.judgements.valueOf("miss").ordinal(), keyelement, keyattrs, numline, keyline, annotline);
                        } else if (keyelement.equals(annotjudgement.getElement())) {
                            annotjudgement.add_alt_attribs(keyattrs, "key");
                            if (annotarr[elembiocol].startsWith("B-")) {
                                annotjudgement.changeJudgement(Judgement.judgements.valueOf("corr").ordinal());
                            } else {
                                annotjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                                annotjudgement.updateNumline(numline);
                            }
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                        } else {
                            keyjudgement = new Judgement(Judgement.judgements.valueOf("miss").ordinal(), keyelement, keyattrs, numline, keyline, annotline);
                        }
                    } else {
                        if (!keyarr[elembiocol].startsWith("I-")) throw new Exception("Malformed BIO format: " + annotarr[elembiocol]);
                        if (keyjudgement != null) {
                            if (!keyjudgement.getElement().equals(keyelement)) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + annotjudgement.getElement());
                            keyjudgement.extendJudgement(keyline, annotline);
                        } else {
                            if (annotjudgement == null) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected O");
                            if (!annotjudgement.getElement().equals(keyelement) || !annotjudgement.isAligned().booleanValue()) throw new Exception("Malformed BIO format: found " + annotarr[elembiocol] + " expected I-" + keyjudgement.getElement());
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                        }
                    }
                } else {
                    if (keyjudgement != null) {
                        score.add(keyjudgement);
                        keyjudgement = null;
                    }
                    if (annotjudgement != null && annotjudgement.isAligned().booleanValue()) {
                        if (annotarr[elembiocol].startsWith("I-") && annotjudgement.getJudgement_str().equals("corr")) {
                            annotjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                        } else if (annotarr[elembiocol].equals("O")) {
                            score.add(annotjudgement);
                            annotjudgement = null;
                        }
                    }
                }
                if (keyarr[elembiocol].equals("O")) {
                    if (annotarr[elembiocol].equals("O")) {
                        score.addtn();
                        continue;
                    }
                    String aelem = annotarr[elembiocol].substring(2).split("-")[0];
                    score.addfp(aelem);
                    score.addtnrest(aelem);
                    continue;
                }
                String kelem = keyarr[elembiocol].substring(2).split("-")[0];
                if (annotarr[elembiocol].equals("O")) {
                    score.addfn(kelem);
                    score.addtnrest(kelem);
                    continue;
                }
                String aelem = annotarr[elembiocol].substring(2).split("-")[0];
                if (kelem.equals(aelem)) {
                    score.addtp(kelem);
                    score.addtnrest(aelem);
                    continue;
                }
                score.addfn(kelem);
                score.addfp(aelem);
            }
            annotline = annotreader.readLine();
            if (annotline == null) return score;
            throw new Exception("Key annotation ended before scored annotation");
        }
        catch (Exception e) {
            System.err.println("\nErrors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + " (line " + numline + ")\n");
            if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) return null;
            e.printStackTrace(System.err);
            System.exit(1);
            return null;
        }
    }

    public Score score_class(String annot, String key, int classcol) {
        Score score = null;
        int numline = 0;
        int classcolk = classcol;
        try {
            String annotline;
            String keyline;
            BufferedReader keyreader = new BufferedReader(new FileReader(key));
            BufferedReader annotreader = new BufferedReader(new FileReader(annot));
            score = new Score(key, annot);
            Judgement judgement = null;
            while ((keyline = keyreader.readLine()) != null) {
                ++numline;
                annotline = annotreader.readLine();
                if (annotline == null) {
                    throw new Exception("Scored annotation ended before key annotation");
                }
                String[] keyarr = keyline.split("\\|");
                String[] annotarr = annotline.split("\\|");
                if (classcol == -1) {
                    classcol = annotarr.length - 1;
                    classcolk = keyarr.length - 1;
                }
                judgement = new Judgement(Judgement.judgements.valueOf("corr").ordinal(), "class", "", numline, keyline, annotline);
                if (!annotarr[classcol].equals(keyarr[classcolk])) {
                    judgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                    score.addfn("class");
                    score.addfp("class");
                } else {
                    score.addtp("class");
                }
                score.add(judgement);
                judgement = null;
            }
            annotline = annotreader.readLine();
            if (annotline != null) {
                throw new Exception("Key annotation ended before scored annotation");
            }
        }
        catch (Exception e) {
            System.err.println("\nErrors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + " (line " + numline + ")\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return score;
    }

    public void compare_scores(Score improved, Score base) {
        Scomp scomp = new Scomp(improved, base);
        scomp.print();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Score autoscore(PipesFile annot, int keybiocol) {
        Score score = null;
        int numline = 0;
        int annotbiocol = keybiocol + 1;
        try {
            String annotline;
            BufferedReader annotreader = new BufferedReader(new FileReader(annot.getFile()));
            score = new Score(annot.getFile().getCanonicalPath(), annot.getFile().getCanonicalPath());
            Judgement keyjudgement = null;
            Judgement annotjudgement = null;
            while ((annotline = annotreader.readLine()) != null) {
                ++numline;
                if (annotline.equals("|") || annotline.equals("")) {
                    if (annotjudgement != null) {
                        score.add(annotjudgement);
                        annotjudgement = null;
                    }
                    if (keyjudgement == null) continue;
                    score.add(keyjudgement);
                    keyjudgement = null;
                    continue;
                }
                String[] annotarr = annotline.split("\\|");
                if (keybiocol == -1) {
                    keybiocol = annotarr.length - 2;
                    annotbiocol = keybiocol + 1;
                }
                if (annotarr.length < annot.getPipesDescArrCount()) {
                    throw new Exception("Malformed pipesFile line: Has less columns than description file");
                }
                if (!annotarr[keybiocol].equals("O") && annotarr[keybiocol].length() < 3 || !annotarr[annotbiocol].equals("O") && annotarr[annotbiocol].length() < 3) {
                    throw new Exception("Malformed BIO format (reading) [" + annotarr[keybiocol] + "] [" + annotarr[annotbiocol] + "]");
                }
                if (!annotarr[annotbiocol].equals("O")) {
                    String annotelement = annotarr[annotbiocol].substring(2);
                    if (annotarr[annotbiocol].startsWith("B-")) {
                        String annotattrs = "*";
                        if (annotjudgement != null) {
                            score.add(annotjudgement);
                            annotjudgement = null;
                        }
                        if (keyjudgement == null || keyjudgement.isAligned().booleanValue()) {
                            annotjudgement = new Judgement(Judgement.judgements.valueOf("spur").ordinal(), annotelement, annotattrs, numline, annotline, annotline);
                            if (keyjudgement != null && annotarr[keybiocol].startsWith("I-") && keyjudgement.getJudgement_str().equals("corr")) {
                                keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                            }
                        } else if (annotelement.equals(keyjudgement.getElement()) && annotarr[keybiocol].startsWith("I-")) {
                            keyjudgement.add_alt_attribs(annotattrs, "annot");
                            keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                        } else {
                            annotjudgement = new Judgement(Judgement.judgements.valueOf("spur").ordinal(), annotelement, annotattrs, numline, annotline, annotline);
                        }
                    } else {
                        if (!annotarr[annotbiocol].startsWith("I-")) throw new Exception("Malformed BIO format (annot): " + annotarr[annotbiocol]);
                        if (annotjudgement != null) {
                            if (!annotjudgement.getElement().equals(annotelement)) throw new Exception("Malformed BIO format (annot): found " + annotarr[annotbiocol] + " expected I-" + annotjudgement.getElement());
                            annotjudgement.extendJudgement(annotline, annotline);
                        } else {
                            if (keyjudgement == null) throw new Exception("Malformed BIO format (annot): found " + annotarr[annotbiocol] + " expected O");
                            if (!keyjudgement.getElement().equals(annotelement) || !keyjudgement.isAligned().booleanValue()) throw new Exception("Malformed BIO format (annot): found " + annotarr[annotbiocol] + " expected I-" + keyjudgement.getElement());
                            if (annotarr[keybiocol].startsWith("B-")) {
                                keyjudgement.changeAndExtendJudgement(Judgement.judgements.valueOf("inco").ordinal(), annotline, annotline);
                            } else {
                                keyjudgement.extendJudgement(annotline, annotline);
                            }
                            annotjudgement = keyjudgement;
                            keyjudgement = null;
                        }
                    }
                } else {
                    if (annotjudgement != null) {
                        score.add(annotjudgement);
                        annotjudgement = null;
                    }
                    if (keyjudgement != null && keyjudgement.isAligned().booleanValue()) {
                        if (annotarr[keybiocol].startsWith("I-") && keyjudgement.getJudgement_str().equals("corr")) {
                            keyjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                        }
                        annotjudgement = keyjudgement;
                        keyjudgement = null;
                    }
                }
                if (!annotarr[keybiocol].equals("O")) {
                    String keyelement = annotarr[keybiocol].substring(2);
                    if (annotarr[keybiocol].startsWith("B-")) {
                        String keyattrs = "*";
                        if (keyjudgement != null) {
                            score.add(keyjudgement);
                            keyjudgement = null;
                        }
                        if (annotjudgement == null || annotjudgement.isAligned().booleanValue()) {
                            keyjudgement = new Judgement(Judgement.judgements.valueOf("miss").ordinal(), keyelement, keyattrs, numline, annotline, annotline);
                            continue;
                        }
                        if (keyelement.equals(annotjudgement.getElement())) {
                            annotjudgement.add_alt_attribs(keyattrs, "key");
                            if (annotarr[annotbiocol].startsWith("B-")) {
                                annotjudgement.changeJudgement(Judgement.judgements.valueOf("corr").ordinal());
                            } else {
                                annotjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                            }
                            keyjudgement = annotjudgement;
                            annotjudgement = null;
                            continue;
                        }
                        keyjudgement = new Judgement(Judgement.judgements.valueOf("miss").ordinal(), keyelement, keyattrs, numline, annotline, annotline);
                        continue;
                    }
                    if (!annotarr[keybiocol].startsWith("I-")) throw new Exception("Malformed BIO format (key): " + annotarr[keybiocol]);
                    if (keyjudgement != null) {
                        if (!keyjudgement.getElement().equals(keyelement)) throw new Exception("Malformed BIO format (key): found " + annotarr[keybiocol] + " expected I-" + annotjudgement.getElement());
                        keyjudgement.extendJudgement(annotline, annotline);
                        continue;
                    }
                    if (annotjudgement == null) throw new Exception("Malformed BIO format (key): found " + annotarr[keybiocol] + " expected O");
                    if (!annotjudgement.getElement().equals(keyelement) || !annotjudgement.isAligned().booleanValue()) throw new Exception("Malformed BIO format (key): found " + annotarr[keybiocol] + " expected I-" + keyjudgement.getElement());
                    keyjudgement = annotjudgement;
                    annotjudgement = null;
                    continue;
                }
                if (keyjudgement != null) {
                    score.add(keyjudgement);
                    keyjudgement = null;
                }
                if (annotjudgement == null || !annotjudgement.isAligned().booleanValue()) continue;
                if (annotarr[annotbiocol].startsWith("I-") && annotjudgement.getJudgement_str().equals("corr")) {
                    annotjudgement.changeJudgement(Judgement.judgements.valueOf("inco").ordinal());
                    keyjudgement = annotjudgement;
                    annotjudgement = null;
                    continue;
                }
                if (!annotarr[annotbiocol].equals("O")) continue;
                score.add(annotjudgement);
                annotjudgement = null;
            }
            annotline = annotreader.readLine();
            if (annotline == null) return score;
            throw new Exception("Key annotation ended before scored annotation");
        }
        catch (Exception e) {
            System.err.println("\nErrors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + " (line " + numline + ")\n");
            if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) return null;
            e.printStackTrace(System.err);
            System.exit(1);
            return null;
        }
    }
}

