#!/bin/bash

SBERT_EN_MODEL="bert-large-nli-mean-tokens"
SBERT_ML_MODEL="distiluse-base-multilingual-cased"

if [[ ! -d "sbert_en" ]]; then
    wget https://public.ukp.informatik.tu-darmstadt.de/reimers/sentence-transformers/v0.2/${SBERT_EN_MODEL}.zip &
fi

if [[ ! -d "sbert_ml" ]]; then
    wget https://public.ukp.informatik.tu-darmstadt.de/reimers/sentence-transformers/v0.2/${SBERT_ML_MODEL}.zip &
fi

if [[ ! -f "glove.840B.300d" ]]; then
    wget http://nlp.stanford.edu/data/glove.840B.300d.zip &
fi

if [[ ! -f "glove_pt_s300" ]]; then
    wget http://143.107.183.175:22980/download.php?file=embeddings/glove/glove_s300.zip -O glove_s300.zip &
fi

wait

echo "Decompressing..."
if [[ -f "glove.840B.300d.zip" ]]; then
    unzip -o glove.840B.300d.zip
fi

if [[ -f "glove_s300.zip" ]]; then
    unzip -o glove_s300.zip
fi

if [[ -f "${SBERT_EN_MODEL}.zip" ]]; then
    unzip -o ${SBERT_EN_MODEL}.zip -d sbert_en/
fi

if [[ -f "${SBERT_ML_MODEL}.zip" ]]; then
    unzip -o ${SBERT_ML_MODEL}.zip -d sbert_ml/
fi

echo "Transformin text file to binaries"
python3 glove_gensim.py

echo "Removing leftovers..."
rm glove.840B.300d.zip
rm glove.840B.300d.txt
rm glove_s300.zip
rm glove_s300.txt
rm ${SBERT_EN_MODEL}.zip
rm ${SBERT_ML_MODEL}.zip

