/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.Category;
import simplenlg.features.ClauseStatus;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.Position;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinatePhrase;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.Spec;
import simplenlg.realiser.StringPhraseSpec;
import simplenlg.realiser.TextSpec;

public abstract class PhraseSpec
extends Spec
implements Phrase {
    Category category;
    DiscourseFunction function = DiscourseFunction.NULL;
    Phrase parentPhrase = null;
    Position position = Position.DEFAULT;
    protected boolean elided = false;

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setDiscourseFunction(DiscourseFunction d) {
        this.function = d;
    }

    @Override
    public DiscourseFunction getDiscourseFunction() {
        return this.function;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public TextSpec promote(DocStructure level) {
        return new TextSpec(new Object[]{level, this});
    }

    @Override
    public boolean isCoordinate() {
        return this instanceof CoordinatePhrase;
    }

    @Override
    public PhraseSpec clone() {
        try {
            return (PhraseSpec)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    protected PhraseSpec makePhraseSpec(Object spec) {
        if (spec instanceof String) {
            Pronoun p = null;
            if (p != null) {
                NPPhraseSpec np = new NPPhraseSpec();
                np.setPronominal(true);
                np.setPronoun(p);
                np.setNumber(p.getNumber());
                np.setGender(p.getGender());
                np.setPerson(p.getPerson());
                return np;
            }
            return new StringPhraseSpec((String)spec);
        }
        if (spec instanceof Pronoun) {
            return new NPPhraseSpec((Noun)spec);
        }
        if (spec instanceof Adjective) {
            return new AdjPhraseSpec((Adjective)spec);
        }
        return (PhraseSpec)spec;
    }

    Phrase makeConstituent(Object arg, DiscourseFunction func) {
        PhraseSpec p = this.makePhraseSpec(arg);
        ((Spec)p).setParentSpec(this);
        if (func != null) {
            p.setDiscourseFunction(func);
        }
        if (p instanceof SPhraseSpec) {
            SPhraseSpec s = (SPhraseSpec)p;
            s.setClauseStatus(ClauseStatus.SUBORDINATE);
            if (func.equals(DiscourseFunction.OBJECT) || func.equals(DiscourseFunction.INDIRECT_OBJECT) || func.equals(DiscourseFunction.PREDICATIVE_COMPLEMENT)) {
                if (s.getForm().equals(Form.IMPERATIVE)) {
                    s.setForm(Form.INFINITIVE);
                    s.suppressComplementiser(true);
                } else if (s.getForm().equals(Form.GERUND) && !s.hasSubject()) {
                    s.suppressComplementiser(true);
                }
            } else if (func.equals(DiscourseFunction.SUBJECT)) {
                s.setForm(Form.GERUND);
                s.suppressComplementiser(true);
            }
            return s;
        }
        return p;
    }

    List<Phrase> makeConstituentList(List<Phrase> constituents, Position pos) {
        ArrayList<Phrase> c = new ArrayList<Phrase>();
        for (Phrase p : constituents) {
            c.add(this.makeConstituent(p, pos.mapToFunction()));
        }
        return c;
    }

    @Override
    public boolean isElided() {
        return this.elided;
    }

    @Override
    public void setElided(boolean elided) {
        this.elided = elided;
    }
}

