/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.ccg.CCGNode;
import edu.pku.coli.ccg.CCGTerminalNode;
import edu.pku.coli.io.CCGBankReader;
import edu.pku.coli.io.CCGPARGReader;
import edu.pku.coli.io.CCGPARGWriter;
import edu.pku.coli.io.CoNLLReader;
import edu.pku.coli.io.FileFilters;
import edu.pku.coli.io.XMLParseResultIO;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.viewer.DepTree;
import edu.pku.coli.viewer.Token;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.xml.sax.SAXException;

public abstract class DAGSentenceReader
implements Iterable<SentenceForDAGParsing> {
    private static final int WORD_COL = 1;
    private static final int POS_COL = 3;
    private static final int MALT_WORD_COL = 0;
    private static final int MALT_POS_COL = 1;

    public static DAGSentenceReader treesReaderFromCoNLL06(String conll) {
        return DAGSentenceReader.treesReaderFromCoNLL06(new File(conll));
    }

    public static DAGSentenceReader treesReaderFromCoNLL06(File file) {
        return DAGSentenceReader.treesReaderFromCoNLL06(file, FileFilters.trivialFileFilter);
    }

    public static DAGSentenceReader treesReaderFromCoNLL06(File file, FileFilter fileFilter) {
        return new TreesFromCoNLL06(file, fileFilter);
    }

    public static DAGSentenceReader treesReaderFromCoNLL08(String conll) {
        return DAGSentenceReader.treesReaderFromCoNLL08(new File(conll));
    }

    public static DAGSentenceReader treesReaderFromCoNLL08(File file) {
        return DAGSentenceReader.treesReaderFromCoNLL08(file, FileFilters.trivialFileFilter);
    }

    public static DAGSentenceReader treesReaderFromCoNLL08(File file, FileFilter fileFilter) {
        return new FromCoNLL08(file, fileFilter, FromCoNLL08.GraphType.TREE_ONLY);
    }

    public static DAGSentenceReader dagsReaderFromCoNLL08(String conll) {
        return DAGSentenceReader.dagsReaderFromCoNLL08(conll, true);
    }

    public static DAGSentenceReader dagsReaderFromCoNLL08(String conll, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromCoNLL08(new File(conll), withTree);
    }

    public static DAGSentenceReader dagsReaderFromCoNLL08(File file) {
        return DAGSentenceReader.dagsReaderFromCoNLL08(file, true);
    }

    public static DAGSentenceReader dagsReaderFromCoNLL08(File file, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromCoNLL08(file, FileFilters.trivialFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromCoNLL08(File file, FileFilter fileFilter, boolean withTree) {
        if (withTree) {
            return new FromCoNLL08(file, fileFilter, FromCoNLL08.GraphType.DAG_WITH_TREE);
        }
        return new FromCoNLL08(file, fileFilter, FromCoNLL08.GraphType.DAG_ONLY);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCoNLL06(String pargFile, String conllFile) {
        return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(pargFile, conllFile, true);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCoNLL06(String pargFile, String conllFile, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(new File(pargFile), new File(conllFile), withTree);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCoNLL06(File pargFile, File conllFile) {
        return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(pargFile, conllFile, true);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCoNLL06(File pargFile, File conllFile, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(pargFile, FileFilters.trivialFileFilter, conllFile, FileFilters.trivialFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCoNLL06(File pargFile, FileFilter pargFileFilter, File conllFile, FileFilter conllFileFilter, boolean withTree) {
        return new DAGsFromPARGwithCoNLL06(pargFile, pargFileFilter, conllFile, conllFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCCGBank(String pargFile, String ccgFile) {
        return DAGSentenceReader.dagsReaderFromPARGwithCCGBank(new File(pargFile), new File(ccgFile));
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCCGBank(File pargFile, File ccgFile) {
        return DAGSentenceReader.dagsReaderFromPARGwithCCGBank(pargFile, FileFilters.trivialFileFilter, ccgFile, FileFilters.ccgAUTOFileFilter);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCCGBank(File pargFile, FileFilter pargFileFilter, File ccgFile, FileFilter ccgFileFilter) {
        return DAGSentenceReader.dagsReaderFromPARGwithCCGBank(pargFile, pargFileFilter, ccgFile, ccgFileFilter, true);
    }

    public static DAGSentenceReader dagsReaderFromPARGwithCCGBank(File pargFile, FileFilter pargFileFilter, File ccgFile, FileFilter ccgFileFilter, boolean withCCGTree) {
        return new DAGsFromPARGwithCCGBank(pargFile, pargFileFilter, ccgFile, ccgFileFilter, withCCGTree);
    }

    public static DAGSentenceReader dagsReaderFromStanfordFormatWithCoNLL06(String stanfordFile, String conllFile) {
        return DAGSentenceReader.dagsReaderFromStanfordFormatWithCoNLL06(stanfordFile, conllFile, true);
    }

    public static DAGSentenceReader dagsReaderFromStanfordFormatWithCoNLL06(String stanfordFile, String conllFile, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromStanfordFormatWithCoNLL06(new File(stanfordFile), new File(conllFile), withTree);
    }

    public static DAGSentenceReader dagsReaderFromStanfordFormatWithCoNLL06(File stanfordFile, File conllFile) {
        return DAGSentenceReader.dagsReaderFromStanfordFormatWithCoNLL06(stanfordFile, conllFile, true);
    }

    public static DAGSentenceReader dagsReaderFromStanfordFormatWithCoNLL06(File stanfordFile, File conllFile, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromStanfordFormatWithCoNLL06(stanfordFile, FileFilters.trivialFileFilter, conllFile, FileFilters.trivialFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromStanfordFormatWithCoNLL06(File stanfordFile, FileFilter stanfordFileFilter, File conllFile, FileFilter conllFileFilter, boolean withTree) {
        return new DAGsFromStanfordFormatWithCoNLL06(stanfordFile, stanfordFileFilter, conllFile, conllFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromXML(String xmlFile) {
        return DAGSentenceReader.dagsReaderFromXML(xmlFile, true);
    }

    public static DAGSentenceReader dagsReaderFromXML(String xmlFile, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromXML(new File(xmlFile), withTree);
    }

    public static DAGSentenceReader dagsReaderFromXML(File xmlFile, boolean withTree) {
        return DAGSentenceReader.dagsReaderFromXML(xmlFile, FileFilters.trivialFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromXML(File xmlFile, FileFilter xmlFileFilter, boolean withTree) {
        return new DAGsFromXML(xmlFile, xmlFileFilter, withTree);
    }

    public static DAGSentenceReader dagsReaderFromSDP(String sdpFile) {
        return new DAGsFromSDP(new File(sdpFile));
    }

    public static DAGSentenceReader dagsReaderFromSDP15(String sdpFile) {
        return new DAGsFromSDP(new File(sdpFile), SDPFormat.SDP15);
    }

    public static DAGSentenceReader dagsReaderFromSDP15(File sdpFile) {
        return new DAGsFromSDP(sdpFile, SDPFormat.SDP15);
    }

    public static DAGSentenceReader dagsReaderFromSDP(File sdpFile) {
        return new DAGsFromSDP(sdpFile);
    }

    public static DAGSentenceReader dagsReaderFromSDPWithoutDAG(String sdpFile) {
        return new DAGsFromSDP(new File(sdpFile), true);
    }

    public static DAGSentenceReader dagsReaderFromSDP15WithoutDAG(String sdpFile) {
        return new DAGsFromSDP(new File(sdpFile), true, SDPFormat.SDP15);
    }

    private DAGSentenceReader() {
    }

    private void listAllFiles(File file, List<File> fileList, FileFilter fileFilter) {
        if (file.isFile()) {
            fileList.add(file);
        } else {
            File[] files;
            File[] fileArray = files = file.listFiles(fileFilter);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.listAllFiles(f, fileList, fileFilter);
                ++n2;
            }
        }
    }

    List<File> listFiles(File dir, FileFilter fileFilter) {
        ArrayList<File> files = new ArrayList<File>();
        this.listAllFiles(dir, files, fileFilter);
        Collections.sort(files);
        return files;
    }

    @Override
    public abstract Iterator<SentenceForDAGParsing> iterator();

    public static DAGSentenceReader newDAGSentenceReader(String dataFormat, String ... files) {
        return DAGSentenceReader.newDAGSentenceReader(dataFormat, false, false, files);
    }

    public static DAGSentenceReader newDAGSentenceReader(String dataFormat, boolean asTree, boolean withTree, String ... files) {
        if (asTree) {
            if ("conll06".equalsIgnoreCase(dataFormat)) {
                return DAGSentenceReader.treesReaderFromCoNLL06(files[0]);
            }
            if ("conll08".equalsIgnoreCase(dataFormat)) {
                return DAGSentenceReader.treesReaderFromCoNLL08(files[0]);
            }
            throw new RuntimeException("Not implemented tree format: " + dataFormat);
        }
        if ("conll08".equalsIgnoreCase(dataFormat)) {
            return DAGSentenceReader.dagsReaderFromCoNLL08(files[0], withTree);
        }
        if ("sdp".equalsIgnoreCase(dataFormat)) {
            return DAGSentenceReader.dagsReaderFromSDP(files[0]);
        }
        if ("sdp15".equalsIgnoreCase(dataFormat)) {
            return DAGSentenceReader.dagsReaderFromSDP15(files[0]);
        }
        throw new RuntimeException("Not implemented dag format: " + dataFormat);
    }

    public static DAGSentenceReader DAGSentenceReaderWithMoreTrees(DAGSentenceReader reader, String treeFiles) {
        return DAGSentenceReader.DAGSentenceReaderWithMoreTrees(reader, treeFiles.split(";"));
    }

    public static DAGSentenceReader DAGSentenceReaderWithMoreTrees(DAGSentenceReader reader, String[] treeFiles) {
        return new MoreTreesReader(reader, treeFiles);
    }

    public static void main(String[] args) {
        DAGSentenceReader r = null;
        CCGPARGWriter writer = null;
        if (args[0].equalsIgnoreCase("CCGBANK")) {
            r = DAGSentenceReader.dagsReaderFromPARGwithCCGBank(new File(args[1]), FileFilters.sectionFileFilter("00-00"), new File(args[2]), FileFilters.sectionFileFilter("00-00"), true);
            if (args.length > 3) {
                writer = new CCGPARGWriter(args[3]);
            }
        } else if (args[0].equalsIgnoreCase("STANFORD")) {
            r = DAGSentenceReader.dagsReaderFromStanfordFormatWithCoNLL06(args[1], args[2]);
            if (args.length > 3) {
                writer = new CCGPARGWriter(args[3]);
            }
        } else if (args[0].equalsIgnoreCase("CONLL06")) {
            r = DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(args[1], args[2]);
            if (args.length > 3) {
                writer = new CCGPARGWriter(args[3]);
            }
        } else if (args[0].equalsIgnoreCase("XML")) {
            r = DAGSentenceReader.dagsReaderFromXML(args[1], false);
            if (args.length > 2) {
                writer = new CCGPARGWriter(args[2]);
            }
        } else if (args[0].equalsIgnoreCase("sdp")) {
            r = DAGSentenceReader.dagsReaderFromSDP(args[1]);
            if (args.length > 2) {
                writer = new CCGPARGWriter(args[2]);
            }
        }
        int all = 0;
        for (SentenceForDAGParsing sent : r) {
            if (!sent.reverse().reverse().equals(sent)) {
                System.out.println("reverse failed: " + sent);
                break;
            }
            ++all;
            if (writer == null) continue;
            writer.printOneSentenceSDP(sent.getGoldDAG(), Arrays.asList(sent.words()), Arrays.asList(sent.lemmas()), Arrays.asList(sent.tags()), sent.id());
        }
        if (writer != null) {
            writer.close();
        }
        System.out.println(all);
    }

    /* synthetic */ DAGSentenceReader(DAGSentenceReader dAGSentenceReader) {
        this();
    }

    private static class DAGsFromPARGwithCCGBank
    extends DAGSentenceReader {
        private List<File> _pargFiles;
        private List<File> _ccgFiles;
        private boolean withCCGTree;

        DAGsFromPARGwithCCGBank(File parg, FileFilter pargFileFilter, File ccgFile, FileFilter ccgFileFilter, boolean withCCGTree) {
            super(null);
            this._pargFiles = this.listFiles(parg, pargFileFilter);
            this._ccgFiles = this.listFiles(ccgFile, ccgFileFilter);
            this.withCCGTree = withCCGTree;
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        private class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int ccgFileIdx = 0;
            int pargFileIdx = 0;
            CCGPARGReader pargReader;
            Iterator<CCGNode> ccgBankIter = null;

            DAGSentenceIterator() {
                if (DAGsFromPARGwithCCGBank.this._pargFiles.isEmpty() || DAGsFromPARGwithCCGBank.this._ccgFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.pargReader = new CCGPARGReader((File)DAGsFromPARGwithCCGBank.this._pargFiles.get(this.pargFileIdx++));
                try {
                    CCGBankReader ccgBankReader = new CCGBankReader((File)DAGsFromPARGwithCCGBank.this._ccgFiles.get(this.ccgFileIdx++));
                    this.ccgBankIter = ccgBankReader.iterator();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.readNext();
            }

            private void readNext() {
                this.nextSent = null;
                String[][] parg = null;
                PredicateArgumentAdjunctDAG dag = null;
                String[] ws = null;
                String[] ps = null;
                try {
                    parg = this.pargReader.readNext();
                    if (parg == null && this.pargFileIdx < DAGsFromPARGwithCCGBank.this._pargFiles.size()) {
                        this.pargReader.close();
                        this.pargReader = new CCGPARGReader((File)DAGsFromPARGwithCCGBank.this._pargFiles.get(this.pargFileIdx++));
                        parg = this.pargReader.readNext();
                    } else if (parg == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                dag = PredicateArgumentAdjunctDAG.buildDagFromPARG(parg);
                CCGNode ccgNode = null;
                if (this.ccgBankIter.hasNext()) {
                    ccgNode = this.ccgBankIter.next();
                } else if (this.ccgFileIdx < DAGsFromPARGwithCCGBank.this._ccgFiles.size()) {
                    try {
                        CCGBankReader ccgBankReader = new CCGBankReader((File)DAGsFromPARGwithCCGBank.this._ccgFiles.get(this.ccgFileIdx++));
                        this.ccgBankIter = ccgBankReader.iterator();
                        ccgNode = this.ccgBankIter.next();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    return;
                }
                if (DAGsFromPARGwithCCGBank.this.withCCGTree) {
                    dag.setCCGTree(ccgNode);
                }
                List terminals = ccgNode.collectTerminalNodes();
                ws = new String[terminals.size()];
                ps = new String[terminals.size()];
                String[] types = new String[terminals.size()];
                int i = 0;
                while (i < terminals.size()) {
                    CCGTerminalNode t = (CCGTerminalNode)terminals.get(i);
                    ws[i] = t.word();
                    ps[i] = t.modPOS();
                    types[i] = t.categoryToString();
                    ++i;
                }
                dag.setTypes(types);
                if (ws.length != dag.sentenceLength()) {
                    throw new RuntimeException("Different sentence length");
                }
                this.nextSent = new SentenceForDAGParsing(ws, ps, dag);
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class DAGsFromPARGwithCoNLL06
    extends DAGSentenceReader {
        private List<File> _pargFiles;
        private List<File> _conllFiles;
        private boolean withTree;

        DAGsFromPARGwithCoNLL06(File parg, FileFilter pargFileFilter, File conll, FileFilter conllFileFilter, boolean withTree) {
            super(null);
            this._pargFiles = this.listFiles(parg, pargFileFilter);
            this._conllFiles = this.listFiles(conll, conllFileFilter);
            this.withTree = withTree;
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        private class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int conllFileIdx = 0;
            CoNLLReader conllReader;
            int pargFileIdx = 0;
            CCGPARGReader pargReader;

            DAGSentenceIterator() {
                if (DAGsFromPARGwithCoNLL06.this._pargFiles.isEmpty() || DAGsFromPARGwithCoNLL06.this._conllFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.conllReader = new CoNLLReader((File)DAGsFromPARGwithCoNLL06.this._conllFiles.get(this.conllFileIdx++));
                this.pargReader = new CCGPARGReader((File)DAGsFromPARGwithCoNLL06.this._pargFiles.get(this.pargFileIdx++));
                this.readNext();
            }

            private void readNext() {
                this.nextSent = null;
                String[][] conll = null;
                String[][] parg = null;
                try {
                    parg = this.pargReader.readNext();
                    if (parg == null && this.pargFileIdx < DAGsFromPARGwithCoNLL06.this._pargFiles.size()) {
                        this.pargReader.close();
                        this.pargReader = new CCGPARGReader((File)DAGsFromPARGwithCoNLL06.this._pargFiles.get(this.pargFileIdx++));
                        parg = this.pargReader.readNext();
                    } else if (parg == null) {
                        return;
                    }
                    conll = this.conllReader.readNext();
                    if (conll == null && this.conllFileIdx < DAGsFromPARGwithCoNLL06.this._conllFiles.size()) {
                        this.conllReader.close();
                        this.conllReader = new CoNLLReader((File)DAGsFromPARGwithCoNLL06.this._conllFiles.get(this.conllFileIdx++));
                        conll = this.conllReader.readNext();
                    } else if (conll == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PredicateArgumentAdjunctDAG dag = null;
                PredicateArgumentAdjunctDAG tree = null;
                dag = PredicateArgumentAdjunctDAG.buildDagFromPARG(parg);
                String[] ws = null;
                String[] ps = null;
                if (conll.length == 4) {
                    ws = conll[0];
                    ps = conll[1];
                    if (DAGsFromPARGwithCoNLL06.this.withTree) {
                        tree = PredicateArgumentAdjunctDAG.buildTreeFromMALT(conll);
                    }
                } else {
                    ws = conll[1];
                    ps = conll[3];
                    if (DAGsFromPARGwithCoNLL06.this.withTree) {
                        tree = PredicateArgumentAdjunctDAG.buildTreeFromCONLL06(conll);
                    }
                }
                this.nextSent = new SentenceForDAGParsing(ws, ps, dag, tree);
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class DAGsFromSDP
    extends DAGSentenceReader {
        private List<File> _sdpFiles;
        private boolean _noDAG;
        private SDPFormat format;

        DAGsFromSDP(File sdpFile, boolean noDAG, SDPFormat format) {
            super(null);
            this._sdpFiles = this.listFiles(sdpFile, FileFilters.trivialFileFilter);
            this._noDAG = noDAG;
            this.format = format;
        }

        DAGsFromSDP(File sdpFile, boolean noDAG) {
            this(sdpFile, noDAG, SDPFormat.SDP14);
        }

        DAGsFromSDP(File sdpFile) {
            this(sdpFile, false);
        }

        DAGsFromSDP(File sdpFile, SDPFormat format) {
            this(sdpFile, false, format);
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int fileIdx = 0;
            CCGPARGReader conllReader;

            public DAGSentenceIterator() {
                if (DAGsFromSDP.this._sdpFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.conllReader = new CCGPARGReader((File)DAGsFromSDP.this._sdpFiles.get(this.fileIdx++));
                this.readNext();
            }

            private void readNext() {
                this.nextSent = null;
                String[][] conll = null;
                try {
                    conll = this.conllReader.readSDPNext();
                    while (conll != null && conll.length <= 1) {
                        conll = this.conllReader.readSDPNext();
                    }
                    if (conll == null && this.fileIdx < DAGsFromSDP.this._sdpFiles.size()) {
                        this.conllReader.close();
                        this.conllReader = new CCGPARGReader((File)DAGsFromSDP.this._sdpFiles.get(this.fileIdx++));
                        conll = this.conllReader.readSDPNext();
                    } else if (conll == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String id = conll[0][0];
                conll = this.transpose(conll);
                PredicateArgumentAdjunctDAG dag = null;
                dag = DAGsFromSDP.this._noDAG || conll.length <= 4 ? new PredicateArgumentAdjunctDAG(conll[0].length) : PredicateArgumentAdjunctDAG.buildDAGFromSDP(conll, DAGsFromSDP.this.format);
                String[] ws = conll[1];
                String[] ls = conll[2];
                String[] ps = conll[3];
                String[] sense = null;
                if (DAGsFromSDP.this.format == SDPFormat.SDP15 && conll.length > 6) {
                    sense = conll[6];
                }
                this.nextSent = new SentenceForDAGParsing(id, ws, ls, ps, sense, dag);
            }

            private String[][] transpose(String[][] conll) {
                if (conll.length <= 1) {
                    return new String[0][0];
                }
                String[][] transposed = new String[conll[1].length][conll.length - 1];
                int i = 1;
                while (i < conll.length) {
                    int j = 0;
                    while (j < transposed.length) {
                        transposed[j][i - 1] = conll[i][j];
                        ++j;
                    }
                    ++i;
                }
                return transposed;
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class DAGsFromStanfordFormatWithCoNLL06
    extends DAGSentenceReader {
        private List<File> _pargFiles;
        private List<File> _conllFiles;
        private boolean withTree;

        DAGsFromStanfordFormatWithCoNLL06(File parg, FileFilter pargFileFilter, File conll, FileFilter conllFileFilter, boolean withTree) {
            super(null);
            this._pargFiles = this.listFiles(parg, pargFileFilter);
            this._conllFiles = this.listFiles(conll, conllFileFilter);
            this.withTree = withTree;
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        private class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int conllFileIdx = 0;
            CoNLLReader conllReader;
            int pargFileIdx = 0;
            CCGPARGReader pargReader;

            DAGSentenceIterator() {
                if (DAGsFromStanfordFormatWithCoNLL06.this._pargFiles.isEmpty() || DAGsFromStanfordFormatWithCoNLL06.this._conllFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.conllReader = new CoNLLReader((File)DAGsFromStanfordFormatWithCoNLL06.this._conllFiles.get(this.conllFileIdx++));
                this.pargReader = new CCGPARGReader((File)DAGsFromStanfordFormatWithCoNLL06.this._pargFiles.get(this.pargFileIdx++));
                this.readNext();
            }

            private void readNext() {
                this.nextSent = null;
                String[][] conll = null;
                String[] parg = null;
                try {
                    parg = this.pargReader.readStanfordNext();
                    if (parg == null && this.pargFileIdx < DAGsFromStanfordFormatWithCoNLL06.this._pargFiles.size()) {
                        this.pargReader.close();
                        this.pargReader = new CCGPARGReader((File)DAGsFromStanfordFormatWithCoNLL06.this._pargFiles.get(this.pargFileIdx++));
                        parg = this.pargReader.readStanfordNext();
                    } else if (parg == null) {
                        return;
                    }
                    conll = this.conllReader.readNext();
                    if (conll == null && this.conllFileIdx < DAGsFromStanfordFormatWithCoNLL06.this._conllFiles.size()) {
                        this.conllReader.close();
                        this.conllReader = new CoNLLReader((File)DAGsFromStanfordFormatWithCoNLL06.this._conllFiles.get(this.conllFileIdx++));
                        conll = this.conllReader.readNext();
                    } else if (conll == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String[] ws = null;
                String[] ps = null;
                PredicateArgumentAdjunctDAG tree = null;
                if (conll.length == 4) {
                    ws = conll[0];
                    ps = conll[1];
                    if (DAGsFromStanfordFormatWithCoNLL06.this.withTree) {
                        tree = PredicateArgumentAdjunctDAG.buildTreeFromMALT(conll);
                    }
                } else {
                    ws = conll[1];
                    ps = conll[3];
                    if (DAGsFromStanfordFormatWithCoNLL06.this.withTree) {
                        tree = PredicateArgumentAdjunctDAG.buildTreeFromCONLL06(conll);
                    }
                }
                PredicateArgumentAdjunctDAG dag = PredicateArgumentAdjunctDAG.buildDagFromStanfordPARG(parg, ws.length);
                this.nextSent = new SentenceForDAGParsing(ws, ps, dag, tree);
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class DAGsFromXML
    extends DAGSentenceReader {
        private List<File> _xmlFiles;
        private boolean withTree;

        public DAGsFromXML(File xmlFile, FileFilter xmlFileFilter, boolean withTree) {
            super(null);
            this._xmlFiles = this.listFiles(xmlFile, xmlFileFilter);
            this.withTree = withTree;
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int fileIdx = 0;
            Iterator<DepTree> dags;
            Iterator<DepTree> trees;
            Iterator<LinkedHashMap<Integer, Token>> tokenLists;

            public DAGSentenceIterator() {
                if (DAGsFromXML.this._xmlFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.readNextXMLFile((File)DAGsFromXML.this._xmlFiles.get(this.fileIdx++));
                this.readNext();
            }

            private void readNextXMLFile(File xmlFile) {
                XMLParseResultIO xmlReader = new XMLParseResultIO(xmlFile.getPath());
                try {
                    xmlReader.importFromFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                this.dags = xmlReader.getDeepdepTreebank().iterator();
                this.tokenLists = xmlReader.getTokenLists().iterator();
                if (DAGsFromXML.this.withTree) {
                    this.trees = xmlReader.getDepTreebank().iterator();
                }
            }

            private void readNext() {
                this.nextSent = null;
                if (!this.dags.hasNext()) {
                    if (this.fileIdx < DAGsFromXML.this._xmlFiles.size()) {
                        this.readNextXMLFile((File)DAGsFromXML.this._xmlFiles.get(this.fileIdx++));
                    } else {
                        return;
                    }
                }
                ArrayList<Token> tokens = new ArrayList<Token>(this.tokenLists.next().values());
                ArrayList<String> wordList = new ArrayList<String>();
                ArrayList<String> posList = new ArrayList<String>();
                DepTree nextDag = this.dags.next();
                PredicateArgumentAdjunctDAG dag = null;
                dag = nextDag != null ? PredicateArgumentAdjunctDAG.builDagFromDepTree(nextDag) : new PredicateArgumentAdjunctDAG(tokens.size());
                PredicateArgumentAdjunctDAG tree = null;
                if (DAGsFromXML.this.withTree) {
                    DepTree nextTree = this.trees.next();
                    if (nextTree != null) {
                        tree = PredicateArgumentAdjunctDAG.builDagFromDepTree(this.trees.next());
                    } else {
                        throw new RuntimeException("No correspoding tree.");
                    }
                }
                int i = 0;
                while (i < tokens.size()) {
                    Token t = (Token)tokens.get(i);
                    if (t.getID() != -1) {
                        wordList.add(t.gethead());
                        String pos = t.getProperty("pos");
                        if (pos != null) {
                            posList.add(pos);
                        } else {
                            System.err.println("no pos");
                        }
                    }
                    ++i;
                }
                Object[] ws = wordList.toArray(new String[0]);
                String[] ps = posList.toArray(new String[0]);
                if (ws.length != dag.sentenceLength()) {
                    System.out.println(Arrays.toString(ws));
                    throw new RuntimeException("Different sentence length: " + ws.length + ":" + dag.sentenceLength());
                }
                this.nextSent = new SentenceForDAGParsing((String[])ws, ps, dag, tree);
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class FromCoNLL08
    extends DAGSentenceReader {
        private List<File> _conllFiles;
        private GraphType graphType;

        FromCoNLL08(File conll, FileFilter fileFilter, GraphType graphType) {
            super(null);
            this._conllFiles = this.listFiles(conll, fileFilter);
            this.graphType = graphType;
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int fileIdx = 0;
            CoNLLReader conllReader;

            public DAGSentenceIterator() {
                if (FromCoNLL08.this._conllFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.conllReader = new CoNLLReader((File)FromCoNLL08.this._conllFiles.get(this.fileIdx++));
                this.readNext();
            }

            private void readNext() {
                this.nextSent = null;
                String[][] conll = null;
                try {
                    conll = this.conllReader.readNext();
                    if (conll == null && this.fileIdx < FromCoNLL08.this._conllFiles.size()) {
                        this.conllReader.close();
                        this.conllReader = new CoNLLReader((File)FromCoNLL08.this._conllFiles.get(this.fileIdx++));
                        conll = this.conllReader.readNext();
                    } else if (conll == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PredicateArgumentAdjunctDAG dag = null;
                PredicateArgumentAdjunctDAG tree = null;
                if (FromCoNLL08.this.graphType == GraphType.TREE_ONLY) {
                    dag = PredicateArgumentAdjunctDAG.buildTreeFromCONLL08(conll);
                } else if (FromCoNLL08.this.graphType == GraphType.DAG_ONLY) {
                    dag = PredicateArgumentAdjunctDAG.buildDagFromCONLL08(conll);
                } else if (FromCoNLL08.this.graphType == GraphType.DAG_WITH_TREE) {
                    dag = PredicateArgumentAdjunctDAG.buildDagFromCONLL08(conll);
                    tree = PredicateArgumentAdjunctDAG.buildTreeFromCONLL08(conll);
                }
                String[] ws = conll[1];
                String[] ps = conll[3];
                this.nextSent = new SentenceForDAGParsing(ws, ps, dag, tree);
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        static enum GraphType {
            TREE_ONLY,
            DAG_ONLY,
            DAG_WITH_TREE;

        }
    }

    private static class MoreTreesReader
    extends DAGSentenceReader {
        File[] treeFiles;
        DAGSentenceReader reader;

        MoreTreesReader(DAGSentenceReader reader, String[] strFiles) {
            super(null);
            this.treeFiles = new File[strFiles.length];
            int i = 0;
            while (i < this.treeFiles.length) {
                this.treeFiles[i] = new File(strFiles[i]);
                ++i;
            }
            this.reader = reader;
        }

        MoreTreesReader(DAGSentenceReader reader, File[] files) {
            super(null);
            this.treeFiles = files;
            this.reader = reader;
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new MoreTreesIterator();
        }

        class MoreTreesIterator
        implements Iterator<SentenceForDAGParsing> {
            Iterator<SentenceForDAGParsing> sentIter;
            List<Iterator<PredicateArgumentAdjunctDAG>> dagIters;

            MoreTreesIterator() {
                this.sentIter = MoreTreesReader.this.reader.iterator();
                this.dagIters = new ArrayList<Iterator<PredicateArgumentAdjunctDAG>>(MoreTreesReader.this.treeFiles.length);
                File[] fileArray = MoreTreesReader.this.treeFiles;
                int n = MoreTreesReader.this.treeFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.dagIters.add(new TreeIterator(file));
                    ++n2;
                }
            }

            @Override
            public boolean hasNext() {
                return this.sentIter.hasNext();
            }

            @Override
            public SentenceForDAGParsing next() {
                SentenceForDAGParsing next = this.sentIter.next();
                ArrayList<PredicateArgumentAdjunctDAG> moreTrees = new ArrayList<PredicateArgumentAdjunctDAG>(MoreTreesReader.this.treeFiles.length);
                for (Iterator<PredicateArgumentAdjunctDAG> dagIter : this.dagIters) {
                    moreTrees.add(dagIter.next());
                }
                next.setMoreSyntaxTrees(moreTrees);
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        class TreeIterator
        implements Iterator<PredicateArgumentAdjunctDAG> {
            CoNLLReader reader;
            String[][] next;

            TreeIterator(File file) {
                this.reader = new CoNLLReader(file);
                try {
                    this.next = this.reader.readNext();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public PredicateArgumentAdjunctDAG next() {
                PredicateArgumentAdjunctDAG ret = null;
                if (this.next.length == 1) {
                    ret = PredicateArgumentAdjunctDAG.buildTreeFromHeadsAndLabels(this.next[0], null);
                } else if (this.next.length == 2) {
                    ret = PredicateArgumentAdjunctDAG.buildTreeFromHeadsAndLabels(this.next[0], this.next[1]);
                } else if (this.next.length == 3) {
                    ret = PredicateArgumentAdjunctDAG.buildTreeFromHeadsAndLabels(this.next[1], this.next[2]);
                } else if (this.next.length == 4) {
                    ret = PredicateArgumentAdjunctDAG.buildTreeFromHeadsAndLabels(this.next[3], this.next[4]);
                }
                try {
                    this.next = this.reader.readNext();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static enum SDPFormat {
        SDP14,
        SDP15;

    }

    private static class TreesFromCoNLL06
    extends DAGSentenceReader {
        private List<File> _conllFiles;

        TreesFromCoNLL06(File conll, FileFilter fileFilter) {
            super(null);
            this._conllFiles = this.listFiles(conll, fileFilter);
        }

        @Override
        public Iterator<SentenceForDAGParsing> iterator() {
            return new DAGSentenceIterator();
        }

        private class DAGSentenceIterator
        implements Iterator<SentenceForDAGParsing> {
            SentenceForDAGParsing nextSent;
            int fileIdx = 0;
            CoNLLReader conllReader;

            DAGSentenceIterator() {
                if (TreesFromCoNLL06.this._conllFiles.isEmpty()) {
                    this.nextSent = null;
                    return;
                }
                this.conllReader = new CoNLLReader((File)TreesFromCoNLL06.this._conllFiles.get(this.fileIdx++));
                this.readNext();
            }

            private void readNext() {
                this.nextSent = null;
                String[][] conll = null;
                try {
                    conll = this.conllReader.readNext();
                    if (conll == null && this.fileIdx < TreesFromCoNLL06.this._conllFiles.size()) {
                        this.conllReader.close();
                        this.conllReader = new CoNLLReader((File)TreesFromCoNLL06.this._conllFiles.get(this.fileIdx++));
                        conll = this.conllReader.readNext();
                    } else if (conll == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PredicateArgumentAdjunctDAG dag = PredicateArgumentAdjunctDAG.buildTreeFromCONLL06(conll);
                String[] ws = conll[1];
                String[] ps = conll[3];
                this.nextSent = new SentenceForDAGParsing(ws, ps, dag);
            }

            @Override
            public boolean hasNext() {
                return this.nextSent != null;
            }

            @Override
            public SentenceForDAGParsing next() {
                if (this.nextSent == null) {
                    throw new NoSuchElementException();
                }
                SentenceForDAGParsing ret = this.nextSent;
                this.readNext();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

