/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.Exceptions;
import fig.basic.StrUtils;
import fig.record.LeafRecordNode;
import fig.record.RecordNode;
import fig.record.RecordNodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StructRecordNode
implements RecordNode {
    private String[] keys;
    private String[] values;

    public StructRecordNode(String[] keys, String[] values) {
        this.keys = keys;
        this.values = values;
        if (keys.length != values.length) {
            throw Exceptions.bad("StructRecordNode: mis-match in length: keys are [%s] (%d), values are [%s] (%d)", StrUtils.join(keys, " | "), keys.length, StrUtils.join(values, " | "), values.length);
        }
    }

    @Override
    public String getKey() {
        return this.keys[0];
    }

    @Override
    public String getValue() {
        return this.values[0];
    }

    @Override
    public double getDoubleValue() {
        return RecordNodeUtils.getDoubleValue(this);
    }

    @Override
    public String getDescription(RecordNode.DescriptionType type) {
        return RecordNodeUtils.getDescription(this.getKey(), this.getValue(), type);
    }

    @Override
    public List<RecordNode> getChildren() {
        ArrayList<RecordNode> children = new ArrayList<RecordNode>();
        int i = 1;
        while (i < this.keys.length) {
            children.add(new LeafRecordNode(this.keys[i], this.values[i]));
            ++i;
        }
        return children;
    }

    @Override
    public List<RecordNode> getChildren(String key) {
        int i = 1;
        while (i < this.keys.length) {
            if (key.equals(this.keys[i])) {
                return Collections.singletonList(new LeafRecordNode(this.keys[i], this.values[i]));
            }
            ++i;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public int numChildren() {
        return this.keys.length - 1;
    }

    @Override
    public int numChildren(String queryKey) {
        String[] stringArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equals(queryKey)) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public void addChild(RecordNode node) {
        throw Exceptions.unsupported;
    }

    @Override
    public RecordNode shallowCopy(String key, String value) {
        String[] newKeys = (String[])this.keys.clone();
        String[] newValues = (String[])this.values.clone();
        newKeys[0] = key;
        newValues[0] = value;
        return new StructRecordNode(newKeys, newValues);
    }

    @Override
    public RecordNode withoutChildren() {
        return new LeafRecordNode(this.getKey(), this.getValue());
    }
}

