/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.GlobalEnv;
import fig.record.OffsetReader;
import fig.record.ReceiverInterface;
import java.io.File;
import java.io.IOException;

public class LoadFileState {
    private GlobalEnv globalEnv;
    private ReceiverInterface receiver;
    private OffsetReader lastReader;

    public LoadFileState(GlobalEnv globalEnv) {
        this.globalEnv = globalEnv;
    }

    public ReceiverInterface getReceiver() {
        return this.receiver;
    }

    public boolean alreadyOpened(File path) {
        return this.alreadyOpened(path.toString());
    }

    public boolean alreadyOpened(String path) {
        return this.lastReader != null && this.lastReader.getPath().equals(path);
    }

    public OffsetReader getReader(File path, int offset) throws IOException {
        return this.getReader(path.toString(), offset);
    }

    public OffsetReader getReader(String path, int offset) throws IOException {
        if (this.alreadyOpened(path)) {
            this.lastReader.setOffset(offset);
        } else {
            this.lastReader = new OffsetReader(path, offset);
        }
        return this.lastReader;
    }

    public void init(ReceiverInterface receiver) {
        this.receiver = receiver;
    }

    public void finish() {
        this.receiver = null;
        if (this.lastReader != null) {
            this.lastReader.closeEasy();
            this.lastReader = null;
        }
    }

    public boolean verbose(int level) {
        return this.globalEnv.verbose(level);
    }

    public int getMaxLoadSize() {
        return this.globalEnv.getMaxLoadSize();
    }
}

