
(* #load "str.cmxa";; *)
(* #load "scripts/trees.ml";; *)

open Str
open String
open Trees


(* formatting exception *)
exception WrongFormat of string;;


(* get dat items *)
let rec write_dat_items = function
    ChildList(Term(sP),ChildList(lch0,ChildList(lch1,End))) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let uP = matched_group 4 sP in
      let dP = matched_group 5 sP in
      let (l0,c0,h0) = write_dat_items lch0 in
      let (l1,c1,h1) = write_dat_items lch1 in
      print_endline ("G : "^uP^" "^dP^" "^lP^":"^cP^"{"^hP^"} = 1");
      print_endline ("Md"^uP^" "^dP^" "^lP^":"^cP^"{"^hP^"} : "^l0^":"^c0^" "^l1^":"^c1^" = 1");
(*      print_endline ("L "^l0^" "^hP^" : "^h0^" = 1");*)
(*      print_endline ("L "^l1^" "^hP^" : "^h1^" = 1");*)
      print_endline ("L l "^(if uP="l" then dP else (string_of_int (1 + int_of_string dP)))^" "^l0^" "^hP^" : "^h0^" = 1");
      print_endline ("L r "^uP^" "^l1^" "^hP^" : "^h1^" = 1");
      (lP,cP,hP)
  | ChildList(Term(sP),ChildList(Term(_) as px,End)) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let l = matched_group 1 sP in
      let c = matched_group 2 sP in
      let h = matched_group 3 sP in
      let u = matched_group 4 sP in
      let d = matched_group 5 sP in
      let (p,x,_) = write_dat_items px in
      print_endline ("G : "^u^" "^d^" "^l^":"^c^"{"^h^"} = 1");
      print_endline ("Md"^u^" "^d^" "^l^":"^c^"{"^h^"} : -:- -:- = 1");
      print_endline ("Cp "^p^" : "^c^" = 1");
      print_endline ("Pw "^x^" : "^p^" = 1");
      print_endline ("Pc "^c^" : "^p^" = 1");
      print_endline ("P : "^p^" = 1");
      (l,c,h)
  | ChildList(Term(sP),_   ) -> raise (WrongFormat sP)
  | ChildList(lch,     End ) -> write_dat_items(lch)
  | ChildList(lch0,    lch1) -> raise (WrongFormat "unlabeled binary branch")
  | Term(s) when string_match (regexp "\\(.*\\)#\\(.*\\)") s 0 ->
      (matched_group 1 s, matched_group 2 s, "")
  | Term(s)                  -> raise (WrongFormat s)
  | End                      -> raise (WrongFormat "unexpected end");;


(* read loop *)
try
  while true do
    let s = input_line stdin in
    let r,t = tree_of_string s in
    let (l,c,h) = write_dat_items t in
    print_endline ("Gr : "^l^":"^c^"{"^h^"} = 1");
    ()
  done;
  None
with
  End_of_file -> None
;;



