import tensorflow as tf

num_units=100
num_layers=2
time_steps=10
encoder_len=20


with tf.Graph().as_default(), tf.Session(config=tf.ConfigProto(allow_soft_placement=True)) as sess:
    X_data = tf.placeholder(tf.float32, [None, time_steps, encoder_len], name='X_data') 
    Z_i_data = tf.placeholder(tf.float32, [None, time_steps+1, encoder_len], name='Z_i_data')
    single_cell = tf.nn.rnn_cell.LSTMCell(
            num_units=num_units, 
            state_is_tuple=True, 
            #state_is_tuple=False, 
            activation=tf.nn.tanh,
            )

    cell = tf.nn.rnn_cell.MultiRNNCell(
            cells=[single_cell] * num_layers, 
            state_is_tuple=True,
            #state_is_tuple=False, 
            )

    X = [tf.squeeze(X_data_, [1]) for X_data_ in tf.split(1, time_steps, X_data)]
    my_output, my_state = tf.nn.rnn(
            cell=cell, 
            inputs=X, 
            dtype=tf.float32, 
            )

    Z_i = [tf.squeeze(Z_i_data_, [1]) for Z_i_data_ in tf.split(1, time_steps+1, Z_i_data)]
    attention_states = tf.concat(1, [tf.reshape(my_output_i, [-1, 1, num_units]) for my_output_i in my_output])
    seq_output, seq_state = tf.nn.seq2seq.attention_decoder(
            decoder_inputs=Z_i, 
            initial_state=my_state, 
            attention_states=attention_states, 
            cell=cell, 
            num_heads=1, 
            dtype=tf.float32, 
            )

