/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.lshorder;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.Property;

public class LSHPhraseContext
extends Property {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String SEP = " ";
    protected EquivalenceClass m_eq;
    protected byte[] m_lshBeforeSig;
    protected byte[] m_lshAfterSig;
    protected byte[] m_lshDiscSig;

    public LSHPhraseContext() {
        this(null, null, null, null);
    }

    public LSHPhraseContext(EquivalenceClass eq, byte[] beforeSig, byte[] afterSig, byte[] discSig) {
        this.m_eq = eq;
        this.m_lshBeforeSig = beforeSig;
        this.m_lshAfterSig = afterSig;
        this.m_lshDiscSig = discSig;
    }

    public EquivalenceClass getEq() {
        return this.m_eq;
    }

    public byte[] getBeforeSig() {
        return this.m_lshBeforeSig;
    }

    public byte[] getAfterSig() {
        return this.m_lshAfterSig;
    }

    public byte[] getDiscSig() {
        return this.m_lshDiscSig;
    }

    @Override
    public String persistToString() throws Exception {
        byte[] allSigs = new byte[this.m_lshBeforeSig.length + this.m_lshAfterSig.length + this.m_lshDiscSig.length];
        System.arraycopy(this.m_lshBeforeSig, 0, allSigs, 0, this.m_lshBeforeSig.length);
        System.arraycopy(this.m_lshAfterSig, 0, allSigs, this.m_lshBeforeSig.length, this.m_lshAfterSig.length);
        System.arraycopy(this.m_lshDiscSig, 0, allSigs, this.m_lshBeforeSig.length + this.m_lshAfterSig.length, this.m_lshDiscSig.length);
        return String.valueOf(this.m_lshBeforeSig.length) + SEP + this.m_lshAfterSig.length + SEP + this.m_lshDiscSig.length + SEP + new String(allSigs, DEFAULT_CHARSET);
    }

    @Override
    public void unpersistFromString(EquivalenceClass eq, String str) throws Exception {
        this.m_eq = eq;
        int one = str.indexOf(SEP);
        int two = str.indexOf(SEP, one + 1);
        int three = str.indexOf(SEP, two + 1);
        this.m_lshBeforeSig = new byte[Integer.parseInt(str.substring(0, one))];
        this.m_lshAfterSig = new byte[Integer.parseInt(str.substring(one + SEP.length(), two))];
        this.m_lshDiscSig = new byte[Integer.parseInt(str.substring(two + SEP.length(), three))];
        byte[] allSigs = str.substring(three + SEP.length()).getBytes(DEFAULT_CHARSET);
        System.arraycopy(allSigs, 0, this.m_lshBeforeSig, 0, this.m_lshBeforeSig.length);
        System.arraycopy(allSigs, this.m_lshBeforeSig.length, this.m_lshAfterSig, 0, this.m_lshAfterSig.length);
        System.arraycopy(allSigs, this.m_lshBeforeSig.length + this.m_lshDiscSig.length, this.m_lshDiscSig, 0, this.m_lshDiscSig.length);
    }
}

