package org.maltparser.parser.algorithm.moreTransition;



	import java.util.Stack;

	import org.maltparser.core.exception.MaltChainedException;
	import org.maltparser.core.syntaxgraph.DependencyStructure;
	import org.maltparser.core.syntaxgraph.edge.Edge;
	import org.maltparser.core.syntaxgraph.node.DependencyNode;
	import org.maltparser.parser.ParserConfiguration;
	import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.nivre.NivreConfig;
	import org.maltparser.parser.history.GuideUserHistory;
	import org.maltparser.parser.history.History;
	import org.maltparser.parser.history.action.ComplexDecisionAction;
	import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.transition.TransitionTable;
	
	public class MoreTransition  extends TransitionSystem {
		protected static final int SHIFT = 1;
		protected static final int REDUCE = 2;
		protected static final int RIGHTARC = 3;
		protected static final int LEFTARC = 4;
		protected static final int LEFTSHORTARC = 5;
		protected static final int RIGHTSHORTARC = 6;
		protected static final int RIGHTARCRED = 7;
		protected static final int SHIFTDUCE = 8;
		protected static final int LEFTARCPOP2 = 9;
		protected static final int LEFTNONPROJARC = 10;
		protected static final int RIGHTNONPROJARC = 11;
		
		public MoreTransition () throws MaltChainedException {
			super();
		}
		
		public void apply(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
			MoreTransitionConfig planarConfig = (MoreTransitionConfig)config;
			Stack<DependencyNode> stack = planarConfig.getStack();
			Stack<DependencyNode> input = planarConfig.getInput();
			currentAction.getAction(actionContainers);
			Edge e = null;
			switch (transActionContainer.getActionCode()) {
			case LEFTSHORTARC:
				e = planarConfig.getDependencyStructure().addDependencyEdge(input.get(planarConfig.getInput().size()-2).getIndex(), input.peek().getIndex());
				addEdgeLabels(e);
				input.pop();
				break;
			case LEFTARC:
				e = planarConfig.getDependencyStructure().addDependencyEdge(input.peek().getIndex(), stack.peek().getIndex());
				addEdgeLabels(e);
				stack.pop();
				break;
			case LEFTNONPROJARC:
				e = planarConfig.getDependencyStructure().addDependencyEdge(input.get(planarConfig.getInput().size()-2).getIndex(), stack.peek().getIndex());
				addEdgeLabels(e);
				stack.pop();
				break;
			case RIGHTNONPROJARC:
				e = planarConfig.getDependencyStructure().addDependencyEdge(stack.peek().getIndex(),input.get(planarConfig.getInput().size()-2).getIndex());
				addEdgeLabels(e);
				DependencyNode a1=input.pop();
				DependencyNode a2=input.pop();
				stack.push(a2);
				input.push(a1);
				break;
			case RIGHTSHORTARC:
				e = planarConfig.getDependencyStructure().addDependencyEdge(input.peek().getIndex(), input.get(planarConfig.getInput().size()-2).getIndex());
				addEdgeLabels(e);
				stack.push(input.pop());
				input.pop();
				input.push(stack.pop());
				
				break;
			case RIGHTARC:
				e = planarConfig.getDependencyStructure().addDependencyEdge(stack.peek().getIndex(), input.peek().getIndex());
				addEdgeLabels(e);
				stack.push(input.pop());
				break;
			case REDUCE:
				stack.pop();
				break;
			default: //SHIFT
				stack.push(input.pop());
				break;
			}
		}
		
		public GuideUserAction getDeterministicAction(GuideUserHistory history, ParserConfiguration config) throws MaltChainedException {
			MoreTransitionConfig planarConfig = (MoreTransitionConfig)config;
			if (planarConfig.getRootHandling() != MoreTransitionConfig.NORMAL && planarConfig.getStack().peek().isRoot()) {
				return updateActionContainers(history, MoreTransition.SHIFT, null);
			}
			//TODO: yeah, shift root
			return null;
		}
		
		protected void addAvailableTransitionToTable(TransitionTable ttable) throws MaltChainedException {
			ttable.addTransition(SHIFT, "SH", false, null);
			ttable.addTransition(REDUCE, "RE", false, null);
			ttable.addTransition(RIGHTARC, "RA", true, null);
			ttable.addTransition(LEFTARC, "LA", true, null);
			ttable.addTransition(LEFTSHORTARC, "LSA", true, null);
			ttable.addTransition(RIGHTSHORTARC, "RSA", true, null);
			ttable.addTransition(LEFTNONPROJARC, "LNP", true, null);
			ttable.addTransition(RIGHTNONPROJARC, "RNP", true, null);
		}
		
		protected void initWithDefaultTransitions(GuideUserHistory history) throws MaltChainedException {
			GuideUserAction currentAction = new ComplexDecisionAction((History)history);
			
			transActionContainer.setAction(SHIFT);
			transActionContainer.setAction(REDUCE);
			for (int i = 0; i < arcLabelActionContainers.length; i++) {
				arcLabelActionContainers[i].setAction(-1);
			}
			currentAction.addAction(actionContainers);
		}
		
		public String getName() {
			return "mt arc-eager";
		}

		public boolean permissible(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
			currentAction.getAction(actionContainers);
			int trans = transActionContainer.getActionCode();
			MoreTransitionConfig planarConfig = (MoreTransitionConfig)config;
			DependencyNode stackPeek = planarConfig.getStack().peek();
			DependencyNode inputPeek = planarConfig.getInput().peek();
			//DependencyStructure dg = planarConfig.getDependencyGraph();
			int rootHandling = planarConfig.getRootHandling();
			//boolean singleHeadConstraint = planarConfig.requiresSingleHead();
			//boolean noCoveredRootsConstraint = planarConfig.requiresNoCoveredRoots();
			//boolean acyclicityConstraint = planarConfig.requiresAcyclicity();
			//boolean connectednessConstraintOnReduce = planarConfig.requiresConnectednessCheckOnReduce();
			//boolean connectednessConstraintOnShift = planarConfig.requiresConnectednessCheckOnShift();
			
			
			if ((trans == LEFTARC || trans == RIGHTARC || trans == LEFTSHORTARC || trans == LEFTARCPOP2 || trans == LEFTNONPROJARC || trans == RIGHTNONPROJARC || trans == RIGHTSHORTARC || trans == RIGHTARCRED) && !isActionContainersLabeled()) {
				return false;
			}

			
			if ((trans == LEFTARC || trans == REDUCE || trans == LEFTNONPROJARC) && stackPeek.isRoot()) { 
				return false;
			}
			if ((trans == LEFTARC) && stackPeek.hasHead()) { 
				return false;
			}
			if (trans == REDUCE && !stackPeek.hasHead() && rootHandling == MoreTransitionConfig.STRICT) {
				return false;
			}
			if (trans == LEFTSHORTARC && planarConfig.getInput().size()<2) {
				return false;
			}
			if (trans == RIGHTSHORTARC && planarConfig.getInput().size()<2) {
				return false;
			}
			if (trans == LEFTNONPROJARC && planarConfig.getInput().size()<2) {
				return false;
			}
			if (trans == RIGHTNONPROJARC && planarConfig.getInput().size()<2) {
				return false;
			}
			if ((trans == LEFTSHORTARC) && inputPeek.hasHead()) { 
				return false;
			}
			if ((trans == LEFTNONPROJARC) && stackPeek.hasHead()) { 
				return false;
			}
			
			
			return true;
		}
		
		public GuideUserAction defaultAction(GuideUserHistory history, ParserConfiguration configuration) throws MaltChainedException {
			return updateActionContainers(history, MoreTransition.SHIFT, null);
		}
	}
