/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.stack;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.stack.Projective;
import org.maltparser.parser.algorithm.stack.ProjectiveOracle;
import org.maltparser.parser.algorithm.stack.StackFactory;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.history.GuideUserHistory;

public class StackProjFactory
extends StackFactory {
    public StackProjFactory(Algorithm algorithm) {
        super(algorithm);
    }

    public TransitionSystem makeTransitionSystem() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Transition system    : Projective\n");
        }
        Projective ts = new Projective();
        ts.setPropagationManager(this.manager.getPropagationManager());
        return ts;
    }

    public OracleGuide makeOracleGuide(GuideUserHistory history) throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Oracle               : Projective\n");
        }
        return new ProjectiveOracle(this.manager, history);
    }
}

