/*
 	APS - Affinity Propagation for Segmentation, a linear text segmenter.
 
    Copyright (C) 2011, Anna Kazantseva

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */


package commandln;

public class ParamGroup implements IParam
{
	protected IParam [] mParams;
	protected IParam mCurrentParam = null;
	
	public ParamGroup(IParam [] params)
	{
		mParams = params;
	}

	public boolean CompareName(String name)
	{
		for (IParam p : mParams)
		{
			if (p.CompareName(name))
			{
				mCurrentParam = p;
				return true;
			}
		}
		
		return false;
	}
	
	public void MarkAsFound() throws Exception
	{
		if (mCurrentParam != null)
			mCurrentParam.MarkAsFound();
		else
			throw new Exception();
	}
	
	public boolean ValueRequired() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.ValueRequired();
		else
			throw new Exception();
	}
	
	public boolean IsMandatory()
	{
		for (IParam p : mParams)
		{
			if (p.IsMandatory())
				return true;
		}
		
		return false;
	}
	
	public boolean IsFound()
	{
		for (IParam p : mParams)
		{
			if (p.IsMandatory() && !p.IsFound())
				return false;
		}
		
		return true;
	}

	public void ParseValue(String value) throws Exception 
	{
		if (mCurrentParam != null)
			mCurrentParam.ParseValue(value);
		else
			throw new Exception();
	}

	public String getString() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getString();
		else
			throw new Exception();
	}
	public int getInt() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getInt();
		else
			throw new Exception();
	}
	public boolean getBool() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getBool();
		else
			throw new Exception();
	}
	public double getDouble() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getDouble();
		else
			throw new Exception();
	}

	public String [] getStringArray() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getStringArray();
		else
			throw new Exception();
	}
	public int [] getIntArray() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getIntArray();
		else
			throw new Exception();
	}
	public double [] getDoubleArray() throws Exception
	{
		if (mCurrentParam != null)
			return mCurrentParam.getDoubleArray();
		else
			throw new Exception();
	}
}
