/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

public class OnlineNormalEstimator {
    private long mN = 0L;
    private double mM = 0.0;
    private double mS = 0.0;

    public void handle(double x) {
        ++this.mN;
        double nextM = this.mM + (x - this.mM) / (double)this.mN;
        this.mS += (x - this.mM) * (x - nextM);
        this.mM = nextM;
    }

    public void unHandle(double x) {
        if (this.mN == 0L) {
            String msg = "Cannot unhandle after 0 samples.";
            throw new IllegalStateException(msg);
        }
        if (this.mN == 1L) {
            this.mN = 0L;
            this.mM = 0.0;
            this.mS = 0.0;
            return;
        }
        double mOld = ((double)this.mN * this.mM - x) / (double)(this.mN - 1L);
        this.mS -= (x - this.mM) * (x - mOld);
        this.mM = mOld;
        --this.mN;
    }

    public long numSamples() {
        return this.mN;
    }

    public double mean() {
        return this.mM;
    }

    public double variance() {
        return this.mN > 1L ? this.mS / (double)this.mN : 0.0;
    }

    public double varianceUnbiased() {
        return this.mN > 1L ? this.mS / (double)(this.mN - 1L) : 0.0;
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double standardDeviationUnbiased() {
        return Math.sqrt(this.varianceUnbiased());
    }

    public String toString() {
        return "Norm(mean=" + this.mean() + ", stdDev=" + this.standardDeviation() + ")[numSamples=" + this.numSamples() + "]";
    }
}

