/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExTokenizerFactory
implements Compilable,
Serializable,
TokenizerFactory {
    static final long serialVersionUID = -1668745791323535436L;
    private final Pattern mPattern;

    public RegExTokenizerFactory(String regex) {
        this(Pattern.compile(regex));
    }

    public RegExTokenizerFactory(String regex, int flags) {
        this(Pattern.compile(regex, flags));
    }

    public RegExTokenizerFactory(Pattern pattern) {
        this.mPattern = pattern;
    }

    public Pattern pattern() {
        return this.mPattern;
    }

    public Tokenizer tokenizer(char[] cs, int start, int length) {
        return new RegExTokenizer(this.mPattern, cs, start, length);
    }

    @Deprecated
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    Object writeReplace() {
        return new Externalizer(this);
    }

    public String toString() {
        return "com.aliasi.tokenizer.RegExTokenizerFactory(pattern=" + this.pattern().pattern() + ", flags=" + this.pattern().flags() + ")";
    }

    static class RegExTokenizer
    extends Tokenizer {
        final Matcher mMatcher;
        final char[] mCs;
        final int mStart;
        final int mLength;
        int mWhiteStart = 0;
        int mTokenStart = 0;
        int mTokenEnd = -1;
        boolean mHasNext = false;
        int mLastTokenStartPosition = -1;
        int mLastTokenEndPosition = -1;

        RegExTokenizer(Pattern pattern, char[] cs, int start, int length) {
            this.mMatcher = pattern.matcher(CharBuffer.wrap(cs, start, length));
            this.mCs = cs;
            this.mStart = start;
            this.mLength = length;
        }

        public String nextToken() {
            return this.hasNextToken() ? this.getNextToken() : null;
        }

        boolean hasNextToken() {
            if (this.mHasNext) {
                return true;
            }
            if (!this.mMatcher.find(this.mWhiteStart)) {
                return false;
            }
            this.mHasNext = true;
            this.mTokenStart = this.mMatcher.start(0);
            this.mTokenEnd = this.mMatcher.end(0);
            return true;
        }

        String getNextToken() {
            String token = new String(this.mCs, this.mStart + this.mTokenStart, this.mTokenEnd - this.mTokenStart);
            this.mWhiteStart = this.mTokenEnd;
            this.mHasNext = false;
            this.mLastTokenStartPosition = this.mTokenStart;
            this.mLastTokenEndPosition = this.mTokenEnd;
            return token;
        }

        public String nextWhitespace() {
            return new String(this.mCs, this.mStart + this.mWhiteStart, (this.hasNextToken() ? this.mTokenStart : this.mLength) - this.mWhiteStart);
        }

        public int lastTokenStartPosition() {
            return this.mLastTokenStartPosition;
        }

        public int lastTokenEndPosition() {
            return this.mLastTokenEndPosition;
        }
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 7772106464245966975L;
        final RegExTokenizerFactory mFactory;

        public Externalizer() {
            this(null);
        }

        public Externalizer(RegExTokenizerFactory factory) {
            this.mFactory = factory;
        }

        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            return new RegExTokenizerFactory((Pattern)in.readObject());
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeObject(this.mFactory.mPattern);
        }
    }
}

