/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import tsg.corpora.ConstCorpus;
import tsg.parser.Grammar;
import util.FileUtil;
import util.Utility;

public class TestSet {
    Grammar grammar;
    ArrayList<ArrayList<Integer>> inputSentences;
    Hashtable<ArrayList<Integer>, Integer> subStrings;
    static final int minSubStringLengthToCache = 1;

    public TestSet(List<String> inputSentences, Grammar structure) {
        this.grammar = structure;
        this.convertInputSentences(inputSentences);
        this.buildSubStringStructure();
        this.removeUniqueSubStrings();
    }

    public boolean containsSubString(ArrayList<Integer> subString) {
        return this.subStrings.containsKey(subString);
    }

    private void convertInputSentences(List<String> sentences) {
        this.subStrings = new Hashtable();
        this.inputSentences = new ArrayList(sentences.size());
        for (String sentence : sentences) {
            String[] sentenceWords = sentence.split("\\s+");
            ArrayList<Integer> sentenceIndexes = new ArrayList<Integer>(sentenceWords.length);
            this.inputSentences.add(sentenceIndexes);
            int i = 0;
            while (i < sentenceWords.length) {
                sentenceIndexes.add(this.grammar.getIndexOfWord(sentenceWords[i]));
                ++i;
            }
        }
    }

    private void buildSubStringStructure() {
        ListIterator<ArrayList<Integer>> s = this.inputSentences.listIterator();
        while (s.hasNext()) {
            ArrayList<Integer> sentenceIndexes = s.next();
            int sentenceLength = sentenceIndexes.size();
            int span = 1;
            while (span <= sentenceLength) {
                int start = 0;
                while (start <= sentenceLength - span) {
                    ArrayList<Integer> fragment = new ArrayList<Integer>(sentenceIndexes.subList(start, start + span));
                    Utility.increaseIntegerListInteger(this.subStrings, fragment, 1);
                    ++start;
                }
                ++span;
            }
        }
    }

    private void removeUniqueSubStrings() {
        Enumeration<ArrayList<Integer>> e = this.subStrings.keys();
        while (e.hasMoreElements()) {
            ArrayList<Integer> key = e.nextElement();
            Integer value = this.subStrings.get(key);
            if (!value.equals(1)) continue;
            this.subStrings.remove(key);
        }
    }

    private void printStructure() {
        File completeOutput = new File("/home/fsangati/Desktop/completeStat");
        File compressOutput = new File("/home/fsangati/Desktop/compressStat");
        TreeSet<Integer> orderedFreq = new TreeSet<Integer>(this.subStrings.values());
        for (Integer freq : orderedFreq) {
            FileUtil.appendReturn("" + freq, completeOutput);
            FileUtil.appendReturn("" + freq, compressOutput);
            int[] lengthStat = new int[40];
            Arrays.fill(lengthStat, 0);
            Enumeration<ArrayList<Integer>> e = this.subStrings.keys();
            while (e.hasMoreElements()) {
                ArrayList<Integer> key = e.nextElement();
                Integer value = this.subStrings.get(key);
                if (!value.equals(freq)) continue;
                int n = key.size();
                lengthStat[n] = lengthStat[n] + 1;
                String fragment = "";
                ListIterator<Integer> l = key.listIterator();
                while (l.hasNext()) {
                    int index = l.next();
                    fragment = index == -1 ? String.valueOf(fragment) + ConstCorpus.unknownTag + " " : String.valueOf(fragment) + this.grammar.lexArray[index] + " ";
                }
                FileUtil.appendReturn("\t" + fragment, completeOutput);
            }
            int j = 0;
            while (j < lengthStat.length) {
                if (lengthStat[j] > 0) {
                    FileUtil.appendReturn("\t" + j + "\t" + lengthStat[j], compressOutput);
                }
                ++j;
            }
        }
    }

    public static void main(String[] args) {
        int[] array1 = new int[]{1, 2, 3};
        int[] array2 = new int[]{1, 2, 3};
        System.out.println(array1.equals(array2));
    }
}

