/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.ArrayList;
import tsg.ConstituencyChars;
import tsg.ConstituencyWords;
import tsg.ConstituencyYield;
import tsg.TSNodeLabel;

public abstract class Constituency {
    TSNodeLabel node;
    boolean countLabel;

    public Constituency(TSNodeLabel node, boolean countLabel) {
        this.node = node;
        this.countLabel = countLabel;
    }

    public abstract Constituency unlabeledCopy();

    public TSNodeLabel getNode() {
        return this.node;
    }

    public String label() {
        return this.node.label();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static ArrayList<? extends Constituency> collectConsituencies(TSNodeLabel tree, boolean labeled, String[] excludeLabels, int const_type, boolean includePos) {
        switch (const_type) {
            case 0: {
                return ConstituencyWords.collectConsituencies(tree, labeled, excludeLabels, includePos);
            }
            case 1: {
                return ConstituencyChars.collectConsituencies(tree, labeled, excludeLabels, includePos);
            }
            case 2: {
                return ConstituencyYield.collectConsituencies(tree, labeled, excludeLabels, includePos);
            }
        }
        return null;
    }

    public static ArrayList<Constituency> makeUnlabeledList(ArrayList<Constituency> list) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        for (Constituency c : list) {
            result.add(c.unlabeledCopy());
        }
        return result;
    }
}

