/*
 * Decompiled with CFR 0.152.
 */
package tsg.corpora;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.Utility;

public class Auxify {
    public static String[] suffixes = new String[]{"'D", "'LL", "'M", "'RE", "'S", "'VE"};
    public static String[] auxgs = new String[]{"BEIN", "BEING", "HAVING"};
    public static String[] auxs = new String[]{"AHM", "AM", "ARE", "ART", "BE", "BEEN", "CAN", "COULD", "DID", "DO", "DOES", "DONE", "DOO", "GET", "GOT", "HAD", "HAFTA", "HAS", "HATH", "HAVE", "IS", "KIN", "MAHT", "MAY", "MAYE", "MIGHT", "MUST", "NEED", "OUGHT", "OUGHTA", "SHALL", "SHOULD", "SHULD", "WAS", "WERE", "WHADDYA", "WILL", "WILLYA", "WOULD"};
    public static String[] verbs = new String[]{"VB", "VBD", "VBG", "VBN", "VBP", "VBZ"};
    public static String[] modals = new String[]{"MD"};
    public static String[] skipInCompounds = new String[]{"ADVP", "RB", "UCP"};

    public static void orderArrays() {
        String s;
        Arrays.sort(suffixes);
        Arrays.sort(auxgs);
        Arrays.sort(auxs);
        Arrays.sort(verbs);
        System.out.println("suffixes");
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            System.out.println("\"" + s + "\",");
            ++n2;
        }
        System.out.println();
        System.out.println("auxgs");
        stringArray = auxgs;
        n = auxgs.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            System.out.println("\"" + s + "\",");
            ++n2;
        }
        System.out.println();
        System.out.println("auxs");
        stringArray = auxs;
        n = auxs.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            System.out.println("\"" + s + "\",");
            ++n2;
        }
        System.out.println();
        System.out.println("verbs");
        stringArray = verbs;
        n = verbs.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            System.out.println("\"" + s + "\",");
            ++n2;
        }
        System.out.println();
    }

    public static boolean hasAuxSuf(String word) {
        int pos = word.indexOf(39);
        if (pos == -1) {
            return false;
        }
        String apostrophe = word.substring(pos);
        return Arrays.binarySearch(suffixes, apostrophe) >= 0;
    }

    public static boolean isAux(String word) {
        return Arrays.binarySearch(auxs, word) >= 0;
    }

    public static boolean isAuxg(String word) {
        return Arrays.binarySearch(auxgs, word) >= 0;
    }

    public static boolean isVerb(String word) {
        return Arrays.binarySearch(verbs, word) >= 0;
    }

    public static String auxify(String pos, String trm) {
        if (pos.startsWith("AUX")) {
            return pos;
        }
        String trmU = trm.toUpperCase();
        if (Auxify.isVerb(pos)) {
            if (Auxify.isAux(trmU) || Auxify.hasAuxSuf(trmU)) {
                return "AUX";
            }
            if (Auxify.isAuxg(trmU)) {
                return "AUXG";
            }
        }
        return null;
    }

    public static boolean auxify(TSNodeLabel t) {
        if (t.isLexical) {
            return false;
        }
        boolean result = false;
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (Auxify.auxify(d)) {
                result = true;
            }
            ++n2;
        }
        if (!t.label.toStringWithoutSemTags().equals("VP")) {
            return result;
        }
        boolean sawVP = false;
        TSNodeLabel[] tSNodeLabelArray2 = t.daughters;
        int n3 = t.daughters.length;
        n = 0;
        while (n < n3) {
            TSNodeLabel d = tSNodeLabelArray2[n];
            String dLabel = d.label.toStringWithoutSemTags();
            if (dLabel.equals("VP")) {
                sawVP = true;
            } else if (!Auxify.isVerb(dLabel) && Arrays.binarySearch(skipInCompounds, dLabel) < 0) {
                return result;
            }
            ++n;
        }
        if (!sawVP) {
            return result;
        }
        tSNodeLabelArray2 = t.daughters;
        n3 = t.daughters.length;
        n = 0;
        while (n < n3) {
            String newPos;
            TSNodeLabel d = tSNodeLabelArray2[n];
            TSNodeLabel l = d.daughters[0];
            if (l.isLexical && (newPos = Auxify.auxify(d.label(), l.label())) != null) {
                d.relabel(newPos);
                result = true;
            }
            ++n;
        }
        return result;
    }

    public static <T> void printHashTable(Hashtable<T, int[]> table) {
        for (T key : table.keySet()) {
            System.out.println("\t" + key + "\t" + table.get(key)[0]);
        }
    }

    public static void auxStatistics() throws Exception {
        Arrays.sort(verbs);
        HashSet<String> allAuxWords = new HashSet<String>();
        allAuxWords.addAll(Arrays.asList(suffixes));
        allAuxWords.addAll(Arrays.asList(auxgs));
        allAuxWords.addAll(Arrays.asList(auxs));
        HashSet<String> verbsPos = new HashSet<String>();
        verbsPos.addAll(Arrays.asList(verbs));
        verbsPos.addAll(Arrays.asList(modals));
        Hashtable statTable = new Hashtable();
        for (String w : allAuxWords) {
            statTable.put(w, new Hashtable());
        }
        File trainingCorpusFile = new File(String.valueOf(Wsj.WsjOriginal) + "wsj-complete.mrg");
        ArrayList<TSNodeLabel> trainingCorpus = Wsj.getTreebank(trainingCorpusFile);
        for (TSNodeLabel tSNodeLabel : trainingCorpus) {
            ArrayList<TSNodeLabel> lex = tSNodeLabel.collectLexicalItems();
            for (TSNodeLabel l : lex) {
                String pos;
                String word = l.label().toUpperCase();
                if (!allAuxWords.contains(word) || !verbsPos.contains(pos = l.parent.label())) continue;
                Hashtable wordStat = (Hashtable)statTable.get(word);
                Utility.increaseInTableInt(wordStat, pos);
            }
        }
        for (Map.Entry entry : statTable.entrySet()) {
            String word = (String)entry.getKey();
            Hashtable table = (Hashtable)entry.getValue();
            System.out.println(word);
            Auxify.printHashTable(table);
            System.out.println("\n");
        }
    }

    public static void main1(String[] args) throws Exception {
        File inputFile = new File("/Users/fedja/Work/Code/TreeGrammars/Viewers/TDS/wsj-00_original.mrg");
        File outputFile = new File("/Users/fedja/Work/Code/TreeGrammars/Viewers/TDS/wsj-00_cleaned_auxify.mrg");
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        ArrayList<TSNodeLabel> constTreebank = Wsj.getTreebankReadableAndClean(inputFile);
        int sentenceIndex = 0;
        for (TSNodeLabel constTree : constTreebank) {
            ++sentenceIndex;
            if (Auxify.auxify(constTree)) {
                System.out.println(sentenceIndex);
            }
            pw.println(constTree.toString());
        }
        pw.close();
    }

    public static void main(String[] args) throws Exception {
        Auxify.auxStatistics();
    }
}

