#!/bin/zsh

# 获取参数
PROGRAM=$1
NUM_EXAMPLES=${2:-5}
MODEL_NAME=${3:-llama2}
FEW_SHOT=${4:-False}
COT=${5:-False}

cat > grouping_evaluation_with_args.sh << EOF
#!/bin/zsh
#PJM -L rscgrp=share
#PJM -L gpu=4
#PJM -L elapse=24:00:00
#PJM -g gk77
#PJM -j
#PJM -N grouping_${PROGRAM}_${MODEL_NAME}_${FEW_SHOT}_${COT}
#PJM -o grouping_${PROGRAM}_${MODEL_NAME}_${FEW_SHOT}_${COT}
#PJM -e grouping_${PROGRAM}_${MODEL_NAME}_${FEW_SHOT}_${COT}

if [ -z "$RUN_ON_REMOTE" ]; then
    source /work/gk77/k77025/.zshrc
fi
PARAMS=(${@})

PROGRAM=${PARAMS[0]}
NUM_EXAMPLES=${PARAMS[1]:-10}
MODEL_NAME=${PARAMS[2]:-gpt-3.5-turbo-16k-0613}
FEW_SHOT=${PARAMS[3]:-True}
COT=${PARAMS[4]:-True}

case $PROGRAM in
"instruction")
python main_grouping.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME --few_shot $FEW_SHOT --cot $COT
;;
"inducting")
python main_grouping_inducting.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME  --few_shot $FEW_SHOT --cot $COT
;;
"error_correction")
python main_grouping_error_correction.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME  --few_shot $FEW_SHOT --cot $COT
;;
"incorporating")
python main_grouping_incorporating.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME  --few_shot $FEW_SHOT --cot $COT
;;
"validating")
python main_grouping_results_validating.py --num_examples $NUM_EXAMPLES --model_name $MODEL_NAME  --few_shot $FEW_SHOT --cot $COT
;;
*)
echo "Unknown program: $PROGRAM"
echo "Usage: $0 {grouping|inducting|error_correction|incorporating|validating}"
exit 1
esac
EOF
# 提交脚本
pjsub grouping_evaluation_with_args.sh



