theory question_74_5
```
imports Main

begin

typedecl entity
typedecl event

consts
  Wire :: "entity ⇒ bool"
  WorkingElectricalCircuit :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  ConductsElectricity :: "entity ⇒ bool"
  Agent :: "entity ⇒ entity ⇒ bool"
  ElectricalCurrent :: "entity ⇒ bool"
  Runs :: "entity ⇒ entity ⇒ bool"
  HeatsUp :: "entity ⇒ bool"
  Causes :: "event ⇒ entity ⇒ bool"
  WillBecome :: "event ⇒ bool"
  Warmer :: "entity ⇒ bool"
  TemperatureIncrease :: "entity ⇒ bool"

(* Explanation 1: A wire is a part of a working electrical circuit that conducts electricity. *)
axiomatization where
  explanation_1: "∀x. Wire x ∧ WorkingElectricalCircuit x ⟶ PartOf x y ∧ WorkingElectricalCircuit y ∧ ConductsElectricity x"

(* Explanation 2: An electrical current runs through the wire in a working electrical circuit. *)
axiomatization where
  explanation_2: "∀x y. Wire x ∧ WorkingElectricalCircuit y ∧ Agent x y ⟶ ElectricalCurrent x ∧ Runs x y"

(* Explanation 3: An electrical current running through a wire causes that wire to heat up, leading to a temperature increase. *)
axiomatization where
  explanation_3: "∀x y e. Wire x ∧ WorkingElectricalCircuit y ∧ ElectricalCurrent x ∧ Runs x y ∧ Agent e x ∧ Patient e x 