theory question_17_5
imports Main

begin

typedecl entity
typedecl event

consts
  Omnivore :: "entity ⇒ bool"
  Consumer :: "entity ⇒ bool"
  FeedsOnPlantMaterial :: "entity ⇒ entity ⇒ bool"
  FeedsOnAnimalMaterial :: "entity ⇒ entity ⇒ bool"
  Feeds :: "event ⇒ entity ⇒ bool"
  TrophicLevelGreaterThanOne :: "event ⇒ bool"

(* Explanation 1: Omnivores are a type of consumer that can feed on both plant and animal material and can have a trophic level greater than one. *)
axiomatization where
  explanation_1: "∀x. Omnivore x ⟶ (Consumer x ∧ (∃y. FeedsOnPlantMaterial x y) ∧ (∃z. FeedsOnAnimalMaterial x z) ∧ (∃e. Feeds e x ∧ TrophicLevelGreaterThanOne e))"

(* Explanation 2: In a feeding event, if the consumer is an omnivore, then the consumer's trophic level in the feeding event is more than one. *)
axiomatization where
  explanation_2: "∀x e. Feeds e x ⟶ (Consumer x ⟶ (Omnivore x ⟶ TrophicLevelGreaterThanOne e))"

theorem hypothesis:
  assumes asm: "Omnivore x"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃e. Feeds e x ∧ TrophicLevelGreaterThanOne e "
proof -
  from asm have "Consumer x" using explanation_1 by blast
  then have "∃e. Feeds e x" using explanation_1 by blast
  then obtain e where e: "Feeds e x" by auto
  have "Omnivore x" using asm by simp
  then have "TrophicLevelGreaterThanOne e" using e explanation_2 by blast
  then show "∃e. Feeds e x ∧ TrophicLevelGreaterThanOne e" using e by simp
qed

end
